/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.agents.party;

import jade.core.Agent;

import java.util.LinkedList;

import taia.plg.behaviours.party.ReplyDanceOfferBehaviour;
import taia.plg.behaviours.party.ReplyDrinkOfferBehaviour;
import taia.plg.behaviours.party.ReplyFoodOfferBehaviour;
import taia.plg.behaviours.party.SetBusyTemporarilyBehaviour;
import taia.plg.behaviours.party.social.GreetingBehaviour;
import taia.plg.behaviours.party.social.ReplyGreetingBehaviour;


@SuppressWarnings("serial")
public abstract class PartyAgent extends Agent
{
	public static final String ASK_DANCE = "ASK_DANCE";
	public static final String NO_DANCE = "NO_DANCE";
	public static final String YES_DANCE = "YES_DANCE";
	
	public static final String GREETINGS = "GREETINGS";
	public static final String GREETINGS_REPLY = "GREETINGS_REPLY";
	public static final String FAREWELL = "FAREWELL";
	public static final String FAREWELL_REPLY = "FAREWELL_REPLY";
	
	//Time the agent is busy, either dancing, eating or drinking
	public static final long BUSY_TIME = 5000;
	
	public static final int PROB_CEIL = 11;
	
	/*Probabilities work like this:
	 * Imagine NO_DANCE_PROB is 7 and PROB_CEIL is 11:
	 * This means that the agent will refuse dancing
	 * 7 out of 10 (11-1) times
	 */
	//Probability of the agent denying a dance
	public static final int NO_DANCE_PROB = 0;
	//Probability of the agent denying a drink
	public static final int NO_DRINK_PROB = 0;
	//...
	public static final int NO_FOOD_PROB  = 0;
	//Probability of the agent leaving the party
	public static final int LEAVE_PARTY_PROB = 11;
	//Probability of proposing a dance
	public static final int PROPOSE_DANCING_PROB = 5;
	
	//Maximal amusement (how many times the agent is willing to dance)
	public static final int MAX_AMUSEMENT = 1;
	//Maximal amount of drinks the agent can consume
	public static final int MAX_DRINKS = 1;
	//Maximal amount of food the agent can consume
	public static final int MAX_FOOD = 1;
	
	protected boolean busy;
	
	private LinkedList<String> drinks;
	private LinkedList<String> food;
	private int amusement;
	

	
	public boolean isBusy()
	{
		return busy;
	}
	
	public void setBusy()
	{
		busy = true;
		addBehaviour(new SetBusyTemporarilyBehaviour(this, BUSY_TIME));
	}
	
	public void notBusy()
	{
		this.busy = false;
	}

	protected void setup()
	{		
		drinks = new LinkedList<String>();
		food = new LinkedList<String>();
		amusement = 0;
		//addBehaviour(new CheckFoodDrink(this, PartyGuestAgent.CHECK_TIME));
		addBehaviour(new ReplyDanceOfferBehaviour());
		addBehaviour(new ReplyDrinkOfferBehaviour());
		addBehaviour(new ReplyFoodOfferBehaviour());
		addBehaviour(new ReplyGreetingBehaviour(GreetingBehaviour.GREETING_PERF, GREETINGS));
	}
	
	public void addDrink(String pDrinkName)
	{
		drinks.addLast(pDrinkName);
	}
	
	public void addFood(String pFoodName)
	{
		food.addLast(pFoodName);
	}
	
	public void increaseAmusement()
	{
		amusement++;
	}
	
	public LinkedList<String> getDrinks()
	{
		return drinks;
	}
	
	public LinkedList<String> getFood()
	{
		return food;
	}
	
	public int getAmusement()
	{
		return amusement;
	}


}
