/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.agents.party;

import java.util.Iterator;

import taia.plg.behaviours.party.ReceiveDrinkBehaviour;
import taia.plg.behaviours.party.ReceiveFoodBehaviour;
import taia.plg.behaviours.party.ReceiveSomethingBehaviour;
import taia.plg.behaviours.party.social.CheckStatusBehaviour;
import taia.plg.behaviours.party.social.SaluteAllBehaviour;
import taia.plg.utilities.DFRegistrar;
import taia.plg.utilities.MessagePrinter;


@SuppressWarnings("serial")
public class PartyGuestAgent extends PartyAgent
{

	private static final String[] services = {DFRegistrar.PARTY_AGENT, DFRegistrar.PARTY_GUEST, DFRegistrar.FOOD, DFRegistrar.DRINK};
	public static final long CHECK_TIME = 5000;
	public static final String SAY_GOODBYE = "SAY_GOODBYE";

	protected void setup()
	{
		super.setup();
		DFRegistrar.registerInDF(this, services);
		
		addBehaviour(new SaluteAllBehaviour(this,CHECK_TIME));
		addBehaviour(new CheckStatusBehaviour(this, CHECK_TIME));
		addBehaviour(new ReceiveDrinkBehaviour(ReceiveSomethingBehaviour.RECEIVE_PERFORMATIVE, ReceiveSomethingBehaviour.RECEIVE_DRINK_CID));
		addBehaviour(new ReceiveFoodBehaviour(ReceiveSomethingBehaviour.RECEIVE_PERFORMATIVE, ReceiveSomethingBehaviour.RECEIVE_FOOD_CID));
	}
	
	protected void takeDown()
	{
		DFRegistrar.deRegisterFromDF(this);
	}

	public void listConsumedItems()
	{
		Iterator<String> itrDrinks = super.getDrinks().iterator();
		Iterator<String> itrFood = super.getFood().iterator();
		
		String consumed = new String();
		while(itrDrinks.hasNext())
		{
			consumed = consumed + itrDrinks.next() + " y ";
		}
		
		while(itrFood.hasNext())
		{
			consumed = consumed + itrFood.next() + " y ";
		}
		
		MessagePrinter.print(this.getLocalName(), "Al menos he llenado la panza con: " + consumed + "ya esta");
	}
	
}
