/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.agents.party;

import jade.lang.acl.ACLMessage;
import taia.plg.behaviours.party.social.ReplyFarewellBehaviour;
import taia.plg.behaviours.party.social.SayFarewellBehaviour;
import taia.plg.utilities.DFRegistrar;

@SuppressWarnings("serial")
public class PartyHostAgent extends PartyAgent
{
	private static final String[] services = {DFRegistrar.PARTY_AGENT, DFRegistrar.PARTY_HOST, DFRegistrar.FOOD, DFRegistrar.DRINK};
	
	public void setup()
	{
		super.setup();
		DFRegistrar.registerInDF(this, services);
		
		addBehaviour(new ReplyFarewellBehaviour(ACLMessage.INFORM,SayFarewellBehaviour.GBYE_CONV_ID));
	}
	
	protected void takeDown()
	{
		DFRegistrar.deRegisterFromDF(this);
	}
}
