/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.agents.waiter;

import taia.plg.behaviours.waiter.OfferDrinkBehaviour;
import taia.plg.consumable.*;
import taia.plg.utilities.DFRegistrar;

@SuppressWarnings("serial")
public class DrinkWaiterAgent extends WaiterAgent {
	
	protected void setup()
	{
		DFRegistrar.registerInDF(this, services);

		Object[] args = getArguments();

		if (args != null && args.length > 0)
		{
			product = new Drink((String) args[0]);
		}
		addBehaviour(new OfferDrinkBehaviour(this,WaiterAgent.OFFER_PERIOD,WaiterAgent.DRINK_CONV_ID));
	}

	protected void takeDown()
	{
		DFRegistrar.deRegisterFromDF(this);
	}
}
