/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.agents.waiter;

import taia.plg.behaviours.waiter.OfferFoodBehaviour;
import taia.plg.consumable.Food;
import taia.plg.utilities.DFRegistrar;

@SuppressWarnings("serial")
public class FoodWaiterAgent extends WaiterAgent {
	
	protected void setup()
	{
		
		DFRegistrar.registerInDF(this, services);

		Object[] args = getArguments();

		if (args != null && args.length > 0)
		{
			product = new Food((String) args[0]);
		}

		addBehaviour(new OfferFoodBehaviour(this,WaiterAgent.OFFER_PERIOD,WaiterAgent.FOOD_CONV_ID));
	}

	protected void takeDown()
	{
		DFRegistrar.deRegisterFromDF(this);
	}
}
