/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.agents.waiter;


import jade.core.Agent;
import taia.plg.consumable.Consumable;
import taia.plg.utilities.DFRegistrar;


@SuppressWarnings("serial")
public class WaiterAgent extends Agent
{

	public static final String DRINK_CONV_ID = "ASK_DRINK";
	public static final String YES_DRINK = "YES_DRINK";
	public static final String NO_DRINK = "NO_DRINK";

	public static final String FOOD_CONV_ID = "ASK_FOOD";
	public static final String YES_FOOD = "YES_FOOD";
	public static final String NO_FOOD = "NO_FOOD";

	public static final long OFFER_PERIOD = 5000;
	public static final long RESTOCK_PERIOD = 15000;
	
	protected static final String[] services = { DFRegistrar.WAITER_AGENT };
	
	public static final int INITIAL_ITEMS_IN_TRAY = 1;
	public static final int MAX_ITEMS_IN_TRAY = 10;

	private int itemsInTray = INITIAL_ITEMS_IN_TRAY;
	private boolean restocking = false;

	
	public boolean isRestocking()
	{
		return restocking;
	}

	
	public void setRestocking(boolean restocking)
	{
		this.restocking = restocking;
	}

	protected Consumable product;


	public boolean trayIsEmpty()
	{
		return itemsInTray == 0;
	}

	public void setItemsInTray(int items)
	{
		itemsInTray = items;
	}

	public Consumable giveProduct()
	{
		itemsInTray--;
		return product;
	}

	public void setProduct(Consumable pProduct)
	{
		product = pProduct;
	}

	public Consumable getProduct()
	{
		return product;
	}
	
	public void printProduct(){
		System.out.println(product);
	}
}
