/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours;

import taia.plg.agents.party.PartyGuestAgent;
import taia.plg.utilities.MessagePrinter;
import taia.plg.utilities.RandomNumGenerator;
import jade.core.Agent;
import jade.wrapper.AgentContainer;
import jade.wrapper.AgentController;
import jade.wrapper.StaleProxyException;
import jade.core.behaviours.TickerBehaviour;


@SuppressWarnings("serial")
public class CreateGuestBehaviour extends TickerBehaviour
{
	public static final int SPAWN_RATE = 2500;
	private static final int SPAWN_CEIL = 11;
	private static final int CREATE_AGENT_PROB = 11;
	private static final int MAX_GUESTS = 1;
	private static int guestNum = 0;

	public CreateGuestBehaviour(Agent a, long period)
	{
		super(a, period);
	}

	@Override
	protected void onTick()
	{
		AgentContainer c = myAgent.getContainerController();
		
		if(guestNum < MAX_GUESTS)
		{
			if(RandomNumGenerator.getRandomNum(SPAWN_CEIL) < CREATE_AGENT_PROB)
			{
				try
				{
					AgentController a = c.createNewAgent("PG" + guestNum, PartyGuestAgent.class.getName(), null );
					a.start();
					
					guestNum++;
					MessagePrinter.print(myAgent.getLocalName(), "CREADO NUEVO GUEST");
				}
				catch (StaleProxyException e)
				{
					e.printStackTrace();
				}
			}
		}
	}

}
