/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.party;

import taia.plg.agents.party.PartyAgent;
import taia.plg.utilities.AgentSearcher;
import taia.plg.utilities.DFRegistrar;
import taia.plg.utilities.MessagePrinter;
import jade.core.AID;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;


@SuppressWarnings("serial")
public class AskDanceBehaviour extends Behaviour
{
	public final static String DANCE_CONV_ID = "danceConv";
	public final static String DANCE_REPLY_W = "danceReply";
	
	private final static int NUM_PASOS = 2;
	
	private int step;
	private String replyID = DANCE_REPLY_W + System.currentTimeMillis();
	
	public AskDanceBehaviour()
	{
		
	}
	
	public void onStart()
	{
		step = 0;
	}

	@Override
	public void action()
	{
		switch(step)
		{
			case 0:
				//Pedir baile
				AID aux = AgentSearcher.getRandomAgentByDF(myAgent, DFRegistrar.PARTY_AGENT);
				
				ACLMessage msgEnviar = new ACLMessage(ACLMessage.PROPOSE);
		    	msgEnviar.setSender(myAgent.getAID());
		    	msgEnviar.addReceiver(aux);		    	
		    	msgEnviar.setContent(PartyAgent.ASK_DANCE);
		    	msgEnviar.setConversationId(DANCE_CONV_ID);
		    	msgEnviar.setReplyWith(replyID);
		    	myAgent.send(msgEnviar);
	
		    	MessagePrinter.print(myAgent.getLocalName(), "A ver si " + aux.getLocalName() + " quiere bailar conmigo...");
		    	
				break;
				
			case 1:
				//Recibir respuesta
				myAgent.addBehaviour(new CyclicBehaviour() 
				{
					@Override
					public void action()
					{
						//Bailar o no
						MessageTemplate mt = MessageTemplate.and(
								MessageTemplate.or(
									MessageTemplate.MatchPerformative(ACLMessage.ACCEPT_PROPOSAL),
									MessageTemplate.MatchPerformative(ACLMessage.REJECT_PROPOSAL)),
								MessageTemplate.and(
									MessageTemplate.MatchConversationId(DANCE_CONV_ID),
									MessageTemplate.MatchInReplyTo(replyID)));
						
						ACLMessage msg = myAgent.receive(mt);
						
						if(msg != null)
						{
							if(msg.getPerformative() == ACLMessage.ACCEPT_PROPOSAL)
							{
								((PartyAgent) myAgent).setBusy();
								MessagePrinter.print(
										myAgent.getLocalName(), "Bien! " + msg.getSender().getLocalName() + " va a bailar conmigo");
								((PartyAgent)myAgent).increaseAmusement();
							}
							else 
							{
								if(msg.getPerformative() == ACLMessage.REJECT_PROPOSAL)
								{
									MessagePrinter.print(
											myAgent.getLocalName(), "Vaya, " + msg.getSender().getLocalName() + " no quiere bailar");
								}
							}
						}
						else
						{
							block();
						}
						
					}
				});				
				break;
				
			default:
				break;
		}
		
		step++;
	}

	@Override
	public boolean done()
	{
		return step == NUM_PASOS;
	}

}
