/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.party;

import jade.lang.acl.ACLMessage;
import jade.lang.acl.UnreadableException;
import taia.plg.agents.party.PartyAgent;
import taia.plg.consumable.Drink;
import taia.plg.utilities.MessagePrinter;

@SuppressWarnings("serial")
public class ReceiveDrinkBehaviour extends ReceiveSomethingBehaviour {

	public ReceiveDrinkBehaviour(int pPerformative, String pConvId) {
		super(pPerformative, pConvId);
	}

	@Override
	protected void getConsumable(ACLMessage msg) {
		try
		{
			Drink aux = (Drink)msg.getContentObject();

			String rdrink = aux.getName();
			((PartyAgent)myAgent).addDrink(rdrink);
			MessagePrinter.print(myAgent.getLocalName(), "recibido " + rdrink);

		}
		catch (UnreadableException e)
		{
			e.printStackTrace();
		}	
	}

}
