/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.party;

import jade.lang.acl.ACLMessage;
import jade.lang.acl.UnreadableException;
import taia.plg.agents.party.PartyAgent;
import taia.plg.consumable.Food;
import taia.plg.utilities.MessagePrinter;

@SuppressWarnings("serial")
public class ReceiveFoodBehaviour extends ReceiveSomethingBehaviour {

	public ReceiveFoodBehaviour(int pPerformative, String pConvId) {
		super(pPerformative, pConvId);
	}

	@Override
	protected void getConsumable(ACLMessage msg) {
		
		try
		{
			Food aux = (Food)msg.getContentObject();
			
			String rfood = aux.getName();
			((PartyAgent)myAgent).addFood(rfood);
			MessagePrinter.print(myAgent.getLocalName(), "recibido "+rfood);
			
		}
		catch (UnreadableException e)
		{
			e.printStackTrace();
		}	
	}

}
