/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.party;

import jade.core.behaviours.CyclicBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;


@SuppressWarnings("serial")
public abstract class ReceiveSomethingBehaviour extends CyclicBehaviour
{
	public static final int RECEIVE_PERFORMATIVE = ACLMessage.INFORM;
	public static final String RECEIVE_FOOD_CID = "RECEIVE_FOOD_CID";
	public static final String RECEIVE_DRINK_CID = "RECEIVE_DRINK_CID";

	private int matchPerf;
	private String matchConv;
	
	public ReceiveSomethingBehaviour(int pPerformative, String pConvId)
	{
		matchPerf = pPerformative;
		matchConv = pConvId;
	}
	
	@Override
	public void action()
	{
		MessageTemplate mt = MessageTemplate.and(
				MessageTemplate.MatchPerformative(matchPerf),
				MessageTemplate.MatchConversationId(matchConv));

		ACLMessage msg = myAgent.receive(mt);
		
		if(msg != null)
		{
			getConsumable(msg);
			onEnd();
		}
		else
		{
			block();
		}
	}
	
	protected abstract void getConsumable(ACLMessage msg);

	public int onEnd()
	{		
		return super.onEnd();		
	}

}
