/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.party;

import jade.lang.acl.ACLMessage;
import taia.plg.agents.party.PartyAgent;
import taia.plg.utilities.MessagePrinter;
import taia.plg.utilities.RandomNumGenerator;


@SuppressWarnings("serial")
public class ReplyDanceOfferBehaviour extends ReplySomethingBehaviour
{
	
	public ReplyDanceOfferBehaviour()
	{
		super(ACLMessage.PROPOSE, AskDanceBehaviour.DANCE_CONV_ID);
	}

	@Override
	protected int generateReplyPerformative()
	{
		int performative;
		
		if(
				((PartyAgent)myAgent).isBusy()||
				(((PartyAgent)myAgent).getAmusement() >= PartyAgent.MAX_AMUSEMENT)||
				(RandomNumGenerator.getRandomNum(PartyAgent.PROB_CEIL) < PartyAgent.NO_DANCE_PROB))
		{
			performative = ACLMessage.REJECT_PROPOSAL;
			MessagePrinter.print(myAgent.getLocalName(), "No me interesa su propuesta");
		}
		else
		{
			performative = ACLMessage.ACCEPT_PROPOSAL;
			MessagePrinter.print(myAgent.getLocalName(), "Bien, bailemos");
			((PartyAgent)myAgent).setBusy();
			((PartyAgent)myAgent).increaseAmusement();
		}	
			
		return performative;
	}
	
}
