/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.party;

import jade.lang.acl.ACLMessage;
import taia.plg.agents.party.PartyAgent;
import taia.plg.agents.waiter.WaiterAgent;
import taia.plg.utilities.RandomNumGenerator;


@SuppressWarnings("serial")
public class ReplyFoodOfferBehaviour extends ReplySomethingBehaviour
{
	
	public ReplyFoodOfferBehaviour()
	{
		super(ACLMessage.PROPOSE, WaiterAgent.FOOD_CONV_ID);
	}

	@Override
	protected int generateReplyPerformative()
	{
		int performative;
		
		if(
			(((PartyAgent)myAgent).isBusy())||
			(((PartyAgent)myAgent).getFood().size() >= PartyAgent.MAX_FOOD)|| 
			(RandomNumGenerator.getRandomNum(PartyAgent.PROB_CEIL) < PartyAgent.NO_FOOD_PROB))
		{
			performative = ACLMessage.REJECT_PROPOSAL;
		}
		else
		{
			performative = ACLMessage.ACCEPT_PROPOSAL;
			((PartyAgent)myAgent).setBusy();
			myAgent.addBehaviour(new ReceiveFoodBehaviour(ACLMessage.INFORM, ReceiveSomethingBehaviour.RECEIVE_FOOD_CID));		
		}
		
		return performative;	
	}

}
