/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.party;

import java.util.Iterator;

import jade.core.AID;
import jade.core.behaviours.CyclicBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;


@SuppressWarnings("serial")
public abstract class ReplySomethingBehaviour extends CyclicBehaviour
{
	
	private int listenPerformative;
	private String listenConvId;
	
	public ReplySomethingBehaviour(int pListenPerformative, String pListenConvId)
	{
		listenPerformative = pListenPerformative;
		listenConvId = pListenConvId;
	}
	
	@Override
	public void action()
	{
		MessageTemplate mt = MessageTemplate.and(
				 MessageTemplate.MatchPerformative(listenPerformative),
				 MessageTemplate.MatchConversationId(listenConvId));
				
		ACLMessage msg = myAgent.receive(mt);
		
		if(msg != null)
		{
			ACLMessage msgReply = msg.createReply();
			msgReply.setPerformative(generateReplyPerformative());	    	
	    	msgReply.setContent(generateReplyContent());  	
	    	myAgent.send(msgReply);
	    	
	    	printReplyMessage(msgReply.getAllReceiver());
		}
		else
		{
			block();
		}
	}
	
	protected abstract int generateReplyPerformative();
	
	protected String generateReplyContent()
	{
		return null;
	}
	

	protected void printReplyMessage(Iterator<AID> pReceiverItr)
	{		
	}


}
