/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.party.social;

import jade.core.Agent;
import jade.core.behaviours.TickerBehaviour;
import taia.plg.agents.party.PartyAgent;
import taia.plg.behaviours.party.AskDanceBehaviour;
import taia.plg.utilities.RandomNumGenerator;


@SuppressWarnings("serial")
public class CheckStatusBehaviour extends TickerBehaviour
{
	public CheckStatusBehaviour(Agent a, long period)
	{
		super(a, period);
	}

	@Override
	protected void onTick()
	{
		//Check if agent has to go
		
		if(
			(((PartyAgent)myAgent).getFood().size() >= PartyAgent.MAX_FOOD) &&
			(((PartyAgent)myAgent).getDrinks().size() >= PartyAgent.MAX_DRINKS) &&
			(((PartyAgent)myAgent).getAmusement() >= PartyAgent.MAX_AMUSEMENT))
		{
			if((RandomNumGenerator.getRandomNum(PartyAgent.PROB_CEIL) < PartyAgent.LEAVE_PARTY_PROB))
			{
				myAgent.addBehaviour(new SayFarewellBehaviour());
			}
		}
		else
		{
			//Check if agent wants to ask someone to dance
			if(((PartyAgent)myAgent).getAmusement() < PartyAgent.MAX_AMUSEMENT)
			{
				if((!((PartyAgent)myAgent).isBusy())&&
				   (RandomNumGenerator.getRandomNum(PartyAgent.PROB_CEIL) < PartyAgent.PROPOSE_DANCING_PROB))
				{
					myAgent.addBehaviour(new AskDanceBehaviour());
				}
			}
		}	
	}
}
