/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.party.social;

import jade.core.AID;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import taia.plg.agents.party.PartyAgent;
import taia.plg.utilities.MessagePrinter;

@SuppressWarnings("serial")
public class GreetingBehaviour extends Behaviour
{
	public final static String GREETINGS_REPLY_W = "greetingsReply";
	public static final int GREETING_PERF = ACLMessage.INFORM;
	public static final int GREETING_REPLY_PERF = ACLMessage.CONFIRM;
	private String replyID = GREETINGS_REPLY_W + System.currentTimeMillis();

	private int step;
	private String convID=PartyAgent.GREETINGS;
	private String content;
	private AID toSalute;
	public GreetingBehaviour(AID pToSalute, String pContent){
		super();
		content=pContent;
		toSalute=pToSalute;
	}
	public void onStart(){
		step=0;
	}
	public void action() 
	{
		switch(step)
		{
			case 0:
				ACLMessage greetings = new ACLMessage(GREETING_PERF);
				
				greetings.addReceiver(toSalute);
				greetings.setSender(myAgent.getAID());
				greetings.setConversationId(convID);
				greetings.setContent(content);
				greetings.setReplyWith(replyID);
				myAgent.send(greetings);
				
				MessagePrinter.print(myAgent.getLocalName(), "Saludos, " + toSalute.getLocalName());
				
				break;
			case 1:
				final MessageTemplate mt = MessageTemplate.and(
						MessageTemplate.and(MessageTemplate.MatchInReplyTo(replyID),
						MessageTemplate.MatchConversationId(convID)),
						MessageTemplate.MatchPerformative(GREETING_PERF));
				
				myAgent.addBehaviour(new WakerBehaviour(myAgent, 100) 
				{
					protected void onWake()
					{
						ACLMessage greetingsReplied = myAgent.receive(mt);
						
						if(greetingsReplied!=null)
						{
							//saludado
						}
					}
				});
				
				break;
		}
		
		step++;		
	}
	
	@Override
	public boolean done() 
	{
		return step==2;
	}

}
