/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.party.social;

import jade.core.AID;

import java.util.Iterator;

import taia.plg.behaviours.party.ReplySomethingBehaviour;
import taia.plg.utilities.MessagePrinter;

@SuppressWarnings("serial")
public class ReplyGreetingBehaviour extends ReplySomethingBehaviour
{ 

	public ReplyGreetingBehaviour(int pListenPerformative, String pListenConvId)
	{
		super(pListenPerformative, pListenConvId);
	}

	@Override
	protected int generateReplyPerformative()
	{
		return GreetingBehaviour.GREETING_REPLY_PERF;
	}

	@Override
	protected String generateReplyContent()
	{
		return null;
	}

	@Override
	protected void printReplyMessage(Iterator<AID> pReceiverItr)
	{
		MessagePrinter.print(myAgent.getLocalName(), "Buenas noches. Cmo se encuentra " + pReceiverItr.next().getLocalName() + "?");
	}

}
