/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.party.social;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.TickerBehaviour;

import java.util.LinkedList;

import taia.plg.utilities.AgentSearcher;
import taia.plg.utilities.DFRegistrar;

@SuppressWarnings("serial")
public class SaluteAllBehaviour extends TickerBehaviour
{
	private LinkedList<AID> toSalute;
	
	public SaluteAllBehaviour(Agent a, long period) 
	{
		super(a, period);
		toSalute=AgentSearcher.getAgentByDF(myAgent, DFRegistrar.PARTY_AGENT);
		toSalute.remove(a.getAID());
	}

	@Override
	protected void onTick() {
		if(!toSalute.isEmpty()){
			myAgent.addBehaviour(new GreetingBehaviour(toSalute.removeFirst(), "hi"));
		}
		else{
			stop();
		}
	}

}
