/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.party.social;

import jade.core.AID;
import jade.core.behaviours.Behaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import taia.plg.agents.party.PartyGuestAgent;
import taia.plg.utilities.AgentSearcher;
import taia.plg.utilities.DFRegistrar;
import taia.plg.utilities.MessagePrinter;


@SuppressWarnings("serial")
public class SayFarewellBehaviour extends Behaviour
{
	private static final int STEP_NUM = 2;
	public static final String GBYE_CONV_ID = "gbyeConv";
	
	private int step;
	public final static String GBYE_REPLY_W = "gbyeReply";
	
	private String replyID = GBYE_REPLY_W + System.currentTimeMillis();
	public void onStart(){
		step=0;
	}
	@Override
	public void action()
	{
		switch(step)
		{
			case 0:
				AID aux = AgentSearcher.getAgentByDF(myAgent, DFRegistrar.PARTY_HOST).getFirst();
				
				ACLMessage msgEnviar = new ACLMessage(ACLMessage.INFORM);
		    	msgEnviar.setSender(myAgent.getAID());
		    	msgEnviar.addReceiver(aux);		    	
		    	msgEnviar.setContent(PartyGuestAgent.SAY_GOODBYE);  
		    	msgEnviar.setConversationId(GBYE_CONV_ID);
		    	msgEnviar.setReplyWith(replyID);
		    	myAgent.send(msgEnviar);
		    	MessagePrinter.print(myAgent.getLocalName(), "Magnfica velada " + aux.getLocalName() + ", mas he de irme");
				break;
				
			case 1:
				//Recibir confirmacion
				MessageTemplate mt = MessageTemplate.and(
						MessageTemplate.MatchPerformative(ACLMessage.INFORM),
							MessageTemplate.and(
								MessageTemplate.MatchConversationId(GBYE_CONV_ID),
								MessageTemplate.MatchInReplyTo(replyID)));
					
				myAgent.blockingReceive(mt);
				
				//Imprimir que se va
				MessagePrinter.print(myAgent.getLocalName(), "(A si mismo)Que pedazo de rollo, yo no vuelvo a estas cenas benficas");
							
				((PartyGuestAgent)myAgent).listConsumedItems();
				break;
				
			default:
				break;
		}
		
		step++;
	}

	@Override
	public boolean done()
	{
		return step == STEP_NUM;
	}
	
	public int onEnd()
	{
		//Matar agente
		myAgent.doDelete();
		return 0;
	}

}
