/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.waiter;

import jade.core.AID;
import jade.lang.acl.ACLMessage;

import java.io.IOException;

import taia.plg.agents.waiter.DrinkWaiterAgent;
import taia.plg.behaviours.party.ReceiveSomethingBehaviour;
import taia.plg.consumable.Drink;

@SuppressWarnings("serial")
public class NegotiateDrinkBehaviour extends NegotiateSomethingBehaviour {

	public NegotiateDrinkBehaviour(AID pAgentId, String pConvID) {
		super(pAgentId, pConvID);
	}

	@Override
	protected ACLMessage setConsumable(ACLMessage msg) {
		try {
			msg.setContentObject((Drink)((DrinkWaiterAgent)myAgent).giveProduct());
		} catch (IOException e) {
			e.printStackTrace();
		}
		return msg;
	}

	@Override
	protected String generateConversationID()
	{
		return ReceiveSomethingBehaviour.RECEIVE_DRINK_CID;
	}

}
