/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.waiter;

import jade.core.AID;
import jade.core.behaviours.Behaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import taia.plg.agents.waiter.WaiterAgent;
import taia.plg.behaviours.party.ReceiveSomethingBehaviour;
import taia.plg.utilities.MessagePrinter;

@SuppressWarnings("serial")
public abstract class NegotiateSomethingBehaviour extends Behaviour{
	protected int step;
	private AID agentId;
	private String convID;
	public NegotiateSomethingBehaviour(AID pAgentId, String pConvID){
		agentId=pAgentId;
		convID=pConvID;
	}
	public void onStart(){
		step=0;
	}
	@Override
	public void action() {
		switch(step){
			//case 0: send something offer
			case 0:
				ACLMessage offer = new ACLMessage(ACLMessage.PROPOSE);
				offer.addReceiver(agentId);
				offer.setPerformative(ACLMessage.PROPOSE);
				offer.setConversationId(convID);
				myAgent.send(offer);
				MessagePrinter.print(myAgent.getLocalName(), agentId.getLocalName()+" le apeteceria "+((WaiterAgent) myAgent).getProduct() + "?");
				step++;
				break;
			//case 1: wait for the answer
			case 1:
				MessageTemplate mt = MessageTemplate.and(
						 MessageTemplate.MatchConversationId(convID),
						 MessageTemplate.or(
								 MessageTemplate.MatchPerformative(ACLMessage.REJECT_PROPOSAL),
								 MessageTemplate.MatchPerformative(ACLMessage.ACCEPT_PROPOSAL)));
						
				ACLMessage msg = myAgent.receive(mt);
				//msg received?
				if(msg!=null){
					//accept
					
					if(msg.getPerformative()==ACLMessage.ACCEPT_PROPOSAL){
						//give the product
						ACLMessage msgReply = new ACLMessage(ReceiveSomethingBehaviour.RECEIVE_PERFORMATIVE);
						msgReply.addReceiver(msg.getSender());
						msgReply.setConversationId(generateConversationID());
						msgReply.setSender(myAgent.getAID());
						
						
						
						
						myAgent.send(setConsumable(msgReply));

						MessagePrinter.print(myAgent.getLocalName(), msg.getSender().getLocalName()+", tenga usted.");
					}
					//reject
					else{
						MessagePrinter.print(myAgent.getLocalName(), msg.getSender().getLocalName()+" no quiere nada de mi bandeja.");
					}
					step++;
				}
				break;
			
		}
	}

	protected abstract String generateConversationID();
	
	protected abstract ACLMessage setConsumable(ACLMessage msg);
	
	@Override
	public boolean done() {
		// TODO Auto-generated method stub
		return step==2;
	}

}
