/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */

package taia.plg.behaviours.waiter;

import jade.core.AID;
import jade.core.Agent;
import taia.plg.agents.waiter.WaiterAgent;
import taia.plg.behaviours.party.social.SayFarewellBehaviour;
import taia.plg.utilities.AgentSearcher;
import taia.plg.utilities.DFRegistrar;


@SuppressWarnings("serial")
public class OfferFoodBehaviour extends OfferSomethingBehaviour
{

	public OfferFoodBehaviour(Agent a, long period, String foodConvId)
	{
		super(a,WaiterAgent.OFFER_PERIOD,WaiterAgent.FOOD_CONV_ID);
	}


	public void negotiate(){
		AID offerToAgent = AgentSearcher.getRandomAgentByDF(myAgent, DFRegistrar.FOOD);
		if(offerToAgent!=null){
			myAgent.addBehaviour(new NegotiateFoodBehaviour(offerToAgent,WaiterAgent.FOOD_CONV_ID));
		}else{
			myAgent.addBehaviour(new SayFarewellBehaviour());
		}
	}

}
