/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */
package taia.plg.utilities;

import jade.core.AID;
import jade.core.Agent;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;

import java.util.LinkedList;

/**
 * This class can be used to search an agnet in the DF
 * by offered services
 * 
 * This class applies a Singleton pattern
 * 
 * @author Alex
 *
 */
public class AgentSearcher
{

	/**
	 * Given an agentType (or service offered by an agent) get all agents
	 * implementing that service otr type
	 * 
	 * @param pAgent Agent object, needed to access the DFService
	 * @param pAgentService String representing the service to be looked for
	 * @return List containing all agents the DFService returned matching pAgentType
	 */
	public static LinkedList<AID> getAgentByDF(Agent pAgent, String pAgentService)
	{
		LinkedList<AID> agents = new LinkedList<AID>();
		DFAgentDescription[] result = null;
		
		try
		{
			//Search in DF
			DFAgentDescription template = new DFAgentDescription();
			ServiceDescription sd = new ServiceDescription();
			sd.setName(pAgentService);
			template.addServices(sd);
			result = DFService.search(pAgent, template);
		}
		catch (FIPAException e)
		{
			e.printStackTrace();
		}
		
		//Extract DF results and put them in a nice structure, like a LinkedList
		if(result != null)
		{			
			for(DFAgentDescription aux:result)
			{
				agents.add(aux.getName());
			}
		}
		
		return agents;
	}
	
	/**
	 * Returns a random agent which matches the given services except itself
	 * @param pAgent
	 * @param pAgentService
	 * @return
	 */
	public static AID getRandomAgentByDF(Agent pAgent, String pAgentService)
	{
		LinkedList<AID> agentList = getAgentByDF(pAgent, pAgentService);
		AID randomAgent=null;		
		int randomNum = 0;
		
		if(agentList.size()>0)
		{
			do
			{
				randomNum = RandomNumGenerator.getRandomNum(agentList.size());
				randomAgent = agentList.get(randomNum);
			}while(randomAgent.equals(pAgent.getAID()));
		}
		
		return randomAgent;		
	}
}
