/**
 * Autores: Alexander Mariel y Jon Ander Garcia
 * Fixed by: Jon Ander Garcia
 * Trabajo para la asignatura TAIA
 * Practica grupal con agentes en la plataforma JADE 
 */
package taia.plg.utilities;

import jade.core.Agent;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;

/**
 * Offers agents registering and deregistering form the containers
 * DF
 * 
 * This object implements the Singleton pattern.
 * 
 * @author Alex
 *
 */
public class DFRegistrar
{
	//Services that can be offered
	public static final String PARTY_AGENT = "partyAgent";
	public static final String PARTY_HOST = "partyHost";
	public static final String PARTY_GUEST = "partyGuest";
	public static final String WAITER_AGENT = "waiterAgent";
	public static final String ENVIRONMENT = "environment";
	public static final String FOOD = "food";
	public static final String DRINK = "drink";
	
	/**
	 * Registers an agent with the given services 
	 * @param pAgent Agent to be registered
	 * @param services Services to be assigned to the agent
	 */
	public static void registerInDF(Agent pAgent, String[] services)
	{
		DFAgentDescription dfd = new DFAgentDescription();
		dfd.setName(pAgent.getAID());
		
		//Add services to the DFAgentdescription
		for(String aux:services)
		{
			ServiceDescription sd = new ServiceDescription();
			sd.setType(aux);
			sd.setName(aux);
			dfd.addServices(sd);
		}		

		try
		{
			//Register agent
			DFService.register(pAgent, dfd);
		}
		catch (FIPAException fe)
		{
			fe.printStackTrace();
		}
	}
	
	/**
	 * Deregister agent from the DF
	 * @param pAgent Agent to be deregistered
	 */
	public static void deRegisterFromDF(Agent pAgent)
	{
		try
		{
			DFService.deregister(pAgent);
		}
		catch (FIPAException fe)
		{
			fe.printStackTrace();
		}
	}

	/**
	 * //+-+-+-+-+ DOES NOT WORK AS INTENTED, AVOID USING THIS METHOD +-+-+-+-+\\
	 * Deregister agent from the services of DF 
	 * @param pAgent
	 * @param services
	 */
	public static void deRegisterFromDF(Agent pAgent, String[] services)
	{		
		DFAgentDescription dfd = new DFAgentDescription();
		dfd.setName(pAgent.getAID());
		
		for(String aux:services)
		{
			ServiceDescription sd = new ServiceDescription();
			sd.setType(aux);
			sd.setName(aux);
			dfd.addServices(sd);
		}	
		
		try
		{
			DFService.deregister(pAgent, dfd);
		}
		catch (FIPAException fe)
		{
			fe.printStackTrace();
		}
	}
	
}
