package partyhard;

import jade.core.behaviours.WakerBehaviour;

import java.util.Random;

@SuppressWarnings("serial")
public class ArrivalBehaviour extends WakerBehaviour {

	
	
	private ArrivalBehaviour(PartyAgent agent, long timeout) {
		super(agent, timeout);
	}
	
	public ArrivalBehaviour(PartyAgent agent) {
		this(agent, getRandomArrivalTime());
	}
	
	private static long getRandomArrivalTime() {
		return new Random().nextInt(Constants.ARRIVAL_TIMESPAN * Constants.SLOWDOWN_FACTOR);
	}

	public PartyAgent getAgent() {
		return (PartyAgent) super.getAgent();
	}
	
	@Override
	protected void onWake() {
		this.getAgent().arrive();
		
		super.onWake();
	}

}
