package partyhard;

import jade.domain.FIPAAgentManagement.ServiceDescription;

@SuppressWarnings("serial")
public class GuestAgent extends PartyAttendingAgent {
	@Override
	protected void setup() {
		super.setup();
		addBehaviour(new ArrivalBehaviour(this));
	}

	protected void arrive() {
		say("Just arriving to the party... Let's see who is already here.");
		sayHelloToEveryone();
		super.arrive();
	}

	protected void leave() {
		say("It's time to go...");
		sayGoodbyeToHost();
		super.leave();
	}

	protected void addServices() {
		super.addServices();
		ServiceDescription guestService = createServiceDescriptionWithNameSet();
		guestService.setType(Constants.SERVICE_NAME_GUEST);
		agentDescription.addServices(guestService);
		notifyAddedService(Constants.SERVICE_NAME_GUEST);
	}

	private void sayHelloToEveryone() {
		saySomethingToGroup(Constants.SERVICE_NAME_PARTY_ATTENDER,
				Constants.MESSAGE_CONTENT_SALUDAR);
	}

	private void sayGoodbyeToHost() {
		saySomethingToGroup(Constants.SERVICE_NAME_HOST,
				Constants.MESSAGE_CONTENT_DESPEDIRSE);
	}
}
