package partyhard;

import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;

@SuppressWarnings("serial")
public class HostAgent extends PartyAttendingAgent {
	private boolean oneGuestWasHere = false;

	@Override
	protected void setup() {
		super.setup();
		arrive();
	}
	
	@Override
	protected void processMessage(ACLMessage msg) {
		if (msg.getContent().toString()
				.equals(Constants.MESSAGE_CONTENT_DESPEDIRSE)) {
			sayTo(msg.getSender(), Constants.MESSAGE_CONTENT_HOST_DESPIDE);
			oneGuestWasHere = true;
		}
		super.processMessage(msg);
	}
	
	@Override
	protected boolean isReadyToGo() {
		return allLeft() && super.isReadyToGo();
	}
	
	@Override
	protected void leave() {
		say("The Party is over now.");
		super.leave();
	}
	
	private boolean allLeft() {
		return noOneHere() && oneGuestWasHere();
	}

	private boolean oneGuestWasHere() {
		return oneGuestWasHere ;
	}

	private boolean noOneHere() {
		return lookForServices(Constants.SERVICE_NAME_GUEST).isEmpty();
	}

	protected void arrive() {
		super.arrive();
		say("I'm here, waiting for my guests!");
	}
	
	protected void addServices() {
		super.addServices();
		ServiceDescription hostService = createServiceDescriptionWithNameSet();
		hostService.setType(Constants.SERVICE_NAME_HOST);
		agentDescription.addServices(hostService);
		notifyAddedService(Constants.SERVICE_NAME_HOST);
	}
}
