package partyhard;

import jade.core.behaviours.TickerBehaviour;

import java.util.Random;

@SuppressWarnings("serial")
public class LeaveBehaviour extends TickerBehaviour {

	private LeaveBehaviour(PartyAgent agent, long timeout) {
		super(agent, timeout);
	}

	public LeaveBehaviour(PartyAgent agent) {
		this(agent, getRandomLeaveTime());
	}

	private static long getRandomLeaveTime() {
		return new Random().nextInt(Constants.LEAVE_TICKER_TIMEPERIOD
				* Constants.SLOWDOWN_FACTOR);
	}

	public PartyAgent getAgent() {
		return (PartyAgent) super.getAgent();
	}

	@Override
	protected void onTick() {
		if (this.getAgent().isReadyToGo()) {
			this.getAgent().leave();
		}

	}

}
