package partyhard;

import jade.core.AID;
import jade.core.Agent;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("serial")
public abstract class PartyAgent extends Agent {
	protected DFAgentDescription agentDescription = new DFAgentDescription();

	protected void setup() {
		addServices();
		addBehaviour(new ReceiveMessageBehaviour(this));
		super.setup();
	}

	protected void arrive() {
		registerServices();
		addBehaviour(new LeaveBehaviour(this));
	}
	
	protected void leave() {
		doDelete();
	}

	protected void processMessage(ACLMessage msg) {
		if (msg.getContent().toString()
				.equals(Constants.MESSAGE_CONTENT_SALUDAR)) {
			sayTo(msg.getSender(), Constants.MESSAGE_CONTENT_GOOD);
		}
	}
	
	protected boolean isReadyToGo() {
		return true;
	}
	
	protected void takeDown() {
		super.takeDown();
		try {
			DFService.deregister(this);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	protected void registerServices() {
		agentDescription.setName(getAID());
		try {
			DFService.register(this, agentDescription);
			// System.out.println("Agent " + getAID() +
			// " successfully registered");
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
	}

	protected ServiceDescription createServiceDescriptionWithNameSet() {
		ServiceDescription saludarService = new ServiceDescription();
		saludarService.setName(getLocalName());
		return saludarService;
	}

	protected void say(String sentence) {
		System.out.println(getLocalName() + ": " + sentence);
	}

	protected void sayTo(AID receiver, String content) {
		ACLMessage msg = new ACLMessage(ACLMessage.INFORM);
		msg.setContent(content);
		msg.addReceiver(receiver);
		System.out.println(getLocalName() + " to " + receiver.getLocalName()
				+ ": " + content);
		send(msg);
	}
	
	protected void sendTo(AID receiver, Serializable content) {
		ACLMessage msg = new ACLMessage(ACLMessage.PROPOSE);
		try {
			msg.setContentObject(content);
		} catch (IOException e) {
			e.printStackTrace();
			return;
		}
		msg.addReceiver(receiver);
		send(msg);
	}

	protected void notifyAddedService(String serviceType) {
		say("Added service: " + serviceType);
	}

	protected List<AID> lookForServices(String type) {
		List<AID> AgentAIDs;

		DFAgentDescription agentDescription = new DFAgentDescription();
		ServiceDescription serviceDescription = new ServiceDescription();

		serviceDescription.setType(type);
		agentDescription.addServices(serviceDescription);
		AgentAIDs = new ArrayList<AID>();

		try {
			DFAgentDescription[] result = DFService.search(this,
					agentDescription);
			for (int i = 0; i < result.length; ++i) {
				AgentAIDs.add(result[i].getName());
			}
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
		return AgentAIDs;
	}

	protected abstract void addServices();

	protected void saySomethingToGroup(String groupServiceName, String text) {
		List<AID> partyAttenders = lookForServices(groupServiceName);
		for (AID aid : partyAttenders) {
			boolean isNotHimself = !(aid.getLocalName().equals(getAID().getLocalName()));
			if(isNotHimself) {
				sayTo(aid, text);
			}
		}
	}
}
