package partyhard;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.UnreadableException;

@SuppressWarnings("serial")
public class PartyAttendingAgent extends PartyAgent {
	private int hambre;
	private int sed;
	private List<Food> eaten;
	private List<Drink> drunk;

	@Override
	protected void setup() {
		hambre = new Random().nextInt(Constants.MAX_HAMBRE);
		sed = new Random().nextInt(Constants.MAX_SED);
		eaten = new ArrayList<Food>();
		drunk = new ArrayList<Drink>();
		super.setup();
	}

	@Override
	protected void leave() {
		for (Food food : eaten) {
			say("I ate: " + food.getName());
		}
		for (Drink drink : drunk) {
			say("I drank: " + drink.getName());
		}
		super.leave();
	}

	protected void eat(Food food) {
		if (hambre > 0) {
			hambre -= food.getAmounthOfHambreDeleted();
			hambre = Math.max(0, hambre);
			eaten.add(food);
			sayConsumed(food.getName());
		} else {
			say("Thank you, but I'm not hungry any more.");
		}
	}

	@Override
	protected void processMessage(ACLMessage msg) {
		if (msg.getPerformative() == ACLMessage.PROPOSE) {
			try {
				Consumable object = (Consumable) msg.getContentObject();
				object.use(this);
			} catch (UnreadableException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		super.processMessage(msg);
	}

	private void sayConsumed(String name) {
		say(Constants.SAY_CONSUMED + name + "!");
	}

	public void drink(Drink drink) {
		sed -= drink.getAmounthOfSedDeleted();
		sed = Math.max(0, sed);
		drunk.add(drink);
		sayConsumed(drink.getName());
	}

	protected void addServices() {
		ServiceDescription saludarService = createServiceDescriptionWithNameSet();
		saludarService.setType(Constants.SERVICE_NAME_PARTY_ATTENDER);
		agentDescription.addServices(saludarService);
		notifyAddedService(Constants.SERVICE_NAME_PARTY_ATTENDER);
	}

	protected boolean isReadyToGo() {
		return hambre <= 0 && sed <= 0 && super.isReadyToGo();
	}
}
