package partyhard;

import java.util.List;
import java.util.Random;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.ServiceDescription;

@SuppressWarnings("serial")
public class WaiterAgent extends PartyAgent {

	@Override
	protected void setup() {
		addBehaviour(new OfferBehaviour(this, Constants.OFFER_PERIOD
				* Constants.SLOWDOWN_FACTOR));
		super.setup();
	}

	protected void addServices() {
		ServiceDescription waiterService = createServiceDescriptionWithNameSet();
		waiterService.setType(Constants.SERVICE_NAME_WAITER);
		agentDescription.addServices(waiterService);
		notifyAddedService(Constants.SERVICE_NAME_WAITER);
	}

	protected void offerConsumableTo(AID receiver, Consumable sellable) {
		sendTo(receiver, sellable);
		System.out.println(getLocalName() + " to " + receiver.getLocalName()
				+ ": I'm offering you a nice " + sellable.getName() + "!");
	}

	public void offerConsumableToSomeone() {
		AID randomAttender = getRandomPartyattender();		
		if (randomAttender != null) {
			offerConsumableTo(randomAttender, getConsumableToSell());
		}
	}
	
	@Override
	protected boolean isReadyToGo() {
		//TODO implementar que se marchan finalmente
		return false;
	}
	

	protected Consumable getConsumableToSell() {
		return getRandomConsumable();
	}

	private Consumable getRandomConsumable() {
		Consumable consumable;
		consumable = new Beer();
		if(new Random().nextInt(2) == 0)
		{
			consumable = new Pintxo();
		}
		return consumable;
	}

	private AID getRandomPartyattender() {
		List<AID> partyAttenders = lookForServices(Constants.SERVICE_NAME_PARTY_ATTENDER);
		if (partyAttenders.isEmpty()) {
			return null;
		}
		return partyAttenders.get(new Random().nextInt(partyAttenders.size()));
	}
}
