package partyscenario;

import java.util.Random;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.TickerBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPANames;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.ProposeInitiator;

public class WaiterAgent extends Agent{
	
	private AID[] invitados;
	private String oferta;
	private int trabajo=0;
	
	
	protected void setup(){
		Object[] args = getArguments();
		DFAgentDescription dfd = new DFAgentDescription();
	    dfd.setName(getAID());
		ServiceDescription sd = new ServiceDescription();
		oferta = (String) args[0];
		sd.setType(oferta);
		sd.setName("Waiter");
		dfd.addServices(sd);
		try {
		   DFService.register(this, dfd);
		 }
		catch (FIPAException fe) {
		   fe.printStackTrace();
		 }
		blockingReceive(MessageTemplate.MatchContent("a trabajar"));
		long ask = Long.parseLong((String)args[1]);
		addBehaviour(new TickerBehaviour(this, ask){

			@Override
			protected void onTick() {
				Random ran = new Random();
				DFAgentDescription template = new DFAgentDescription();
	            ServiceDescription sd1 = new ServiceDescription();
	            sd1.setType("attendant");
	            template.addServices(sd1);
	            SearchConstraints ALL = new SearchConstraints();
	            ALL.setMaxResults(new Long(-1));
	            try {
	            	DFAgentDescription[] result = DFService.search(myAgent, template, ALL);
	            	invitados = new AID[result.length];
	                for (int ik = 0; ik < result.length; ik++) {
	                  invitados[ik] = result[ik].getName();
	                }
	                ACLMessage mensaje = new ACLMessage(ACLMessage.PROPOSE);
	    	        mensaje.setProtocol(FIPANames.InteractionProtocol.FIPA_PROPOSE);
	    	        mensaje.setContent(oferta);
	    	        AID target = invitados[ran.nextInt(invitados.length)];
	    	        mensaje.addReceiver(target);
	    	        System.out.println("\n\n"+myAgent.getLocalName()+ ": agente " + target.getLocalName() + " desea un poco de " +oferta+"?");
	    	        myAgent.addBehaviour(new ofrecimiento(myAgent, mensaje));
	            }
	            catch (FIPAException fe) {
	            	fe.printStackTrace();
		        }
			}
		});
		
	}
	protected void takeDown(){
		try {
			DFService.deregister(this);
			System.out.println(getLocalName()+": un placer trabajar para usted");
		} catch (FIPAException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	private class ofrecimiento extends ProposeInitiator {
        public ofrecimiento(Agent agente, ACLMessage mensaje) {
            super(agente, mensaje);
        }
 
        protected void handleAcceptProposal(ACLMessage aceptacion) {
            System.out.println(myAgent.getLocalName()+ ": Aqui tiene " + aceptacion.getSender().getLocalName());
            trabajo++;
        }
 
        protected void handleRejectProposal(ACLMessage rechazo) {
        	System.out.println(myAgent.getLocalName()+ ": Como desee " + rechazo.getSender().getLocalName()); 
        }
    }
}
