package tareagrupo;

import java.util.Random;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.TickerBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

public class Anfitrion extends Agent {

	private AID[] listaInvitados;
	int comida=0;
	int bebida=0;
	int tragos=0;
	private long tini;
	
	protected void setup() {

		// Registrar party-host
		DFAgentDescription description = new DFAgentDescription();
		description.setName(getAID());
		ServiceDescription serviceDescription = new ServiceDescription();
		serviceDescription.setType("party-host");
		serviceDescription.setName(getAID().getLocalName());
		description.addServices(serviceDescription);
		try {
			DFService.register(this, description);
			System.out.println(getAID().getLocalName() + " ha llegado. Empieza la fiesta!!!");
			System.out.println();
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}

		// Buscar invitados
		//buscarInvitados();
		//doWait(10000);
		//addBehaviour(new Escuchar());
		addBehaviour(new Escuchar());
		addBehaviour(new Comprobar(this, 1000));

	}
	
	private class Escuchar extends CyclicBehaviour {
		MessageTemplate tratarSaludos;
		MessageTemplate tratarComida;
		MessageTemplate tratarAdios;

		public void action() {
			tratarSaludos = MessageTemplate.MatchConversationId("Saludo");
			tratarComida = MessageTemplate.MatchConversationId("Comida");
			tratarAdios = MessageTemplate.MatchConversationId("Despedida");
			ACLMessage msg = myAgent.receive(tratarSaludos);
			ACLMessage msg2 = myAgent.receive(tratarComida);
			ACLMessage msg3 = myAgent.receive(tratarAdios);
			if (msg != null) {
				// Se ha recibido un mensaje de Saludo y lo procesamos
				ACLMessage reply = msg.createReply();
				reply.setConversationId("ResponderSaludo");
				reply.setContent("Que pasa troncoo");
				//reply.setPerformative(ACLMessage.CFP);
				System.out.println("[" + getLocalName() + "]: Que pasa "
						+ msg.getSender().getLocalName() + "!!!");
				send(reply);
			
			} else if (msg2 != null) {
				// Se ha recibido un mensaje de Comida/Bebida y lo procesamos
				ACLMessage reply2 = msg2.createReply();
				reply2.setConversationId("ResponderComida");
				Random rand = new Random();
				int ranNum = rand.nextInt(10 - 1 + 1) + 1;
				if (ranNum == 3) {
					reply2.setContent("Gin Tonic");
					bebida++;
					tragos++;
				} else if (ranNum <= 2){
					reply2.setContent("Cerbeza");
					bebida++;
					tragos++;
				}else if (ranNum == 4){
					reply2.setContent("Patxaran");
					bebida++;
					tragos++;
				}else if (ranNum == 5){
					reply2.setContent("Martini");
					bebida++;
					tragos++;
				}else if (ranNum == 5){
					reply2.setContent("Ron");
					bebida++;
					tragos++;
				}else if (ranNum == 6){
					reply2.setContent("Whisky");
					bebida++;
					tragos++;
				}else if (ranNum == 7){
					reply2.setContent("Agua");
					bebida--;
				}else if (ranNum > 7){
					reply2.setContent("Comida");
					comida++;
				}
				reply2.setPerformative(ACLMessage.REQUEST);
				System.out.println("[" + getLocalName() + "]: Dame un poco de "
						+ reply2.getContent() + " "
						+ msg2.getSender().getLocalName() + "!!!");
				send(reply2);
			}else if (msg3 != null) {
				// Se ha recibido un mensaje de Adios y lo procesamos
				ACLMessage reply = msg3.createReply();
				reply.setConversationId("ResponderAdios");
				reply.setContent("Adios");
				//reply.setPerformative(ACLMessage.CFP);
				System.out.println("[" + getLocalName() + "]: Muchas gracias por venir!!! Hasta otra "
						+ msg3.getSender().getLocalName() + "!!!");
				send(reply);
			} else {
				block();
			}
		}

	}
	private class Comprobar extends TickerBehaviour {

		int minticks;

		public Comprobar(Agent a, long intervalo) {
			super(a, intervalo);
			minticks = 0;
		}

		public void reset() {
			super.reset();
		}

		protected void onTick() {
			long tfin = System.currentTimeMillis() - tini;
			int nticks = getTickCount();
			buscarInvitados();
			minticks++;
			if (nticks == 10) {
				if (listaInvitados.length==0) {
					
						System.out.println("[" + getLocalName()
								+ "]: Buenooo, por fin se acabo esto. He bebido "+tragos+" tragos y ya estoy borracho y cansado. A dormir!!!\n");
						try {
							DFService.deregister(myAgent);
						} catch (FIPAException e) {
							e.printStackTrace();
						}
							doDelete();
				} else {
					Random rand = new Random();
					int ranNum = rand.nextInt(10 - 1 + 1) + 1;
					if (ranNum == 3) {
						System.out.println("[" + getLocalName()
								+ "]: Boommmmbaaaa\n");
					} else if (ranNum <= 2) {
						System.out.println("[" + getLocalName()
								+ "]: Esto si que es una fiesta!\n");
					} else if (ranNum == 4) {
						System.out.println("[" + getLocalName()
								+ "]: Soy el mejor en estoooo\n");
					} else if (ranNum == 5) {
						System.out.println("[" + getLocalName()
								+ "]: Soy el rey de la fiestaaa!!!\n");
					}
					reset();
				}
			}
		}
	}

	private void buscarInvitados() {
		DFAgentDescription agentDescription = new DFAgentDescription();
		ServiceDescription serviceDescription = new ServiceDescription();

		serviceDescription.setType("party-guest");
		agentDescription.addServices(serviceDescription);

		try {
			DFAgentDescription[] result = DFService.search(this,
					agentDescription);
			listaInvitados = new AID[result.length];
			//System.out.println("Invitados:");
			for (int i = 0; i < result.length; ++i) {
				listaInvitados[i] = result[i].getName();
				//System.out.println(result[i].getName().getLocalName());
			}
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
		//System.out.println();
	}

}
