package tareagrupo;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.TickerBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

public class Camarero extends Agent {

	private AID[] listaInvitados;
	private AID[] listaAnfitrion;
	private long tini;
	int ronda=1;
	protected void setup() {
		doWait(10000);
		// Registrar party-host
		DFAgentDescription description = new DFAgentDescription();
		description.setName(getAID());
		ServiceDescription serviceDescription = new ServiceDescription();
		serviceDescription.setType("camarero");
		serviceDescription.setName(getAID().getLocalName());
		description.addServices(serviceDescription);
		try {
			DFService.register(this, description);
			System.out
			.println("---------------------------------------------------------------------------------");
	System.out
			.println("["
					+ getLocalName()
					+ "] : El camarero entra en la sala... En seguida empiezo a trabajar");
	System.out
			.println("---------------------------------------------------------------------------------\n");
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
		// Buscar invitados y anfitrion
		// addBehaviour(new Escuchar());
		addBehaviour(new OfrecerComida(this, 1000));
	}

	private class OfrecerComida extends TickerBehaviour {
		int minticks;

		public OfrecerComida(Agent a, long intervalo) {
			super(a, intervalo);
			minticks = 0;
		}

		public void reset() {
			super.reset();
		}

		public void onTick() {
			MessageTemplate tratarRespuestasComida;
			boolean fin = false;
			long tfin = System.currentTimeMillis() - tini;
			int nticks = getTickCount();
			minticks++;

			if (nticks == 18) {
				buscarInvitados();
				buscarAnfitrion();
				System.out
				.println("---------------------------------------------------------------------------------");
		System.out
				.println("["
						+ getLocalName()
						+ "] : Ronda "+ronda+" de servicio de camarero!!!!");
		System.out
				.println("---------------------------------------------------------------------------------\n");
				ronda++;
				if(listaAnfitrion.length!=0){
				for (int i = 0; i < listaInvitados.length; i++) {
					ACLMessage msg = new ACLMessage(ACLMessage.PROPOSE);
					msg.addReceiver(listaInvitados[i]);
					msg.setConversationId("Comida");
					msg.setContent("Tipo de comida");
					System.out.println("[" + getLocalName()
							+ "]: Quieres comer/beber algo "
							+ listaInvitados[i].getLocalName() + "?");
					send(msg);
					doWait(2000);
					tratarRespuestasComida = MessageTemplate
							.MatchConversationId("ResponderComida");
					ACLMessage respuesta = myAgent.receive(tratarRespuestasComida);
					if (respuesta != null) {
						//if (respuesta.getPerformative() == ACLMessage.CFP) {
							System.out.println("[" + getLocalName()
									+ "]: Aqui tienes tu "+respuesta.getContent()
									+" "+ respuesta.getSender().getLocalName() + "!!");
							System.out.println();

						//}
					} else {
						block();
					}
				}
				doWait(2000);
				for (int i = 0; i < listaAnfitrion.length; i++) {
					ACLMessage msg = new ACLMessage(ACLMessage.PROPOSE);
					msg.addReceiver(listaAnfitrion[i]);
					msg.setConversationId("Comida");
					msg.setContent("Tipo de comida");
					System.out.println("[" + getLocalName()
							+ "]: Quieres comer/beber algo "
							+ listaAnfitrion[i].getLocalName() + "?");
					send(msg);
					doWait(2000);
					tratarRespuestasComida = MessageTemplate
							.MatchConversationId("ResponderComida");
					ACLMessage respuesta = myAgent.receive(tratarRespuestasComida);
					if (respuesta != null) {
						//if (respuesta.getPerformative() == ACLMessage.CFP) {
							System.out.println("[" + getLocalName()
									+ "]: Aqui tienes tu "+respuesta.getContent()
									+" "+ respuesta.getSender().getLocalName() + "!!");
							System.out.println();

						//}
					} else {
						block();
					}
				}
			}else{
				doWait(5000);
				System.out.println("[" + getLocalName()
						+ "]: Ya estamos como siempre, me dejan solo para recoger todo... Pues que les den, me piroooo\n");
				try {
					DFService.deregister(myAgent);
				} catch (FIPAException e) {
					e.printStackTrace();
				}
				doDelete();
			}
				reset();
			} else {
			}
		}

	}

	private void buscarInvitados() {
		DFAgentDescription agentDescription = new DFAgentDescription();
		ServiceDescription serviceDescription = new ServiceDescription();
		serviceDescription.setType("party-guest");
		agentDescription.addServices(serviceDescription);

		try {
			DFAgentDescription[] result = DFService.search(this,
					agentDescription);
			listaInvitados = new AID[result.length];
			// System.out.println("[" + getLocalName() + "] Invitados sala:");
			for (int i = 0; i < result.length; ++i) {
				listaInvitados[i] = result[i].getName();
				// System.out.println(result[i].getName().getLocalName());
			}
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
		// System.out.println();
	}

	private void buscarAnfitrion() {
		DFAgentDescription agentDescription = new DFAgentDescription();
		ServiceDescription serviceDescription = new ServiceDescription();
		serviceDescription.setType("party-host");
		agentDescription.addServices(serviceDescription);

		try {
			DFAgentDescription[] result = DFService.search(this,
					agentDescription);
			listaAnfitrion = new AID[result.length];
			// System.out.println("[" + getLocalName()
			// + "] Anfitriones de la fiesta:");
			for (int i = 0; i < result.length; ++i) {

				listaAnfitrion[i] = result[i].getName();
				// System.out.println(result[i].getName().getLocalName());
			}
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
		// System.out.println();
	}

}
