package tareagrupo;

import java.util.Random;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.TickerBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

public class Invitado extends Agent {

	private AID[] listaInvitados;
	private AID[] listaAnfitrion;
	private long tini;
	// Atributos para controlar el apetito y el nivel de borrachera del invitado
	private int bebida = 0;
	private int tragos = 0;
	private int comida = 0;

	protected void setup() {
		Object[] args = getArguments();

		if (args[0].equals("1")) {
			doWait(5000);
		}if (args[0].equals("2")) {
			doWait(10000);
		}if (args[0].equals("3")) {
			doWait(15000);
		}if (args[0].equals("4")) {
			doWait(20000);
		}if (args[0].equals("5")) {
			doWait(25000);
		}if (args[0].equals("6")) {
			doWait(30000);
		}if (args[0].equals("7")) {
			doWait(35000);
		}if (args[0].equals("8")) {
			doWait(40000);
		}if (args[0].equals("9")) {
			doWait(45000);
		}if (args[0].equals("10")) {
			doWait(50000);
		}
		// Registrar party-host
		DFAgentDescription description = new DFAgentDescription();
		description.setName(getAID());
		ServiceDescription serviceDescription = new ServiceDescription();
		serviceDescription.setType("party-guest");
		serviceDescription.setName(getAID().getLocalName());
		description.addServices(serviceDescription);
		try {
			DFService.register(this, description);
			// System.out.println(getAID().getLocalName() + " ha llegado.");
			// System.out.println();
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}

		// Buscar invitados y anfitrion
		buscarInvitados();
		buscarAnfitrion();
		addBehaviour(new Saludar());
		addBehaviour(new Escuchar());
		addBehaviour(new Comprobar(this, 1000));



	}

	private class Saludar extends Behaviour {

		MessageTemplate tratarRespuestasSaludo;
		boolean fin = false;

		public void onStart() {
			System.out
					.println("---------------------------------------------------------------------------------");
			System.out
					.println("["
							+ getLocalName()
							+ "] : He entrado... Vamos a saludar a los invitados que estn en la sala.");
			System.out
					.println("---------------------------------------------------------------------------------\n");
		}

		public void action() {

			for (int i = 0; i < listaInvitados.length; i++) {
				ACLMessage cfp = new ACLMessage(ACLMessage.CFP);
				cfp.addReceiver(listaInvitados[i]);
				cfp.setConversationId("Saludo");
				cfp.setContent("Hola");
				System.out.println("[" + getLocalName()
						+ "]: Que tal va la noche "
						+ listaInvitados[i].getLocalName() + "!!!");
				send(cfp);
				doWait(2000);
				tratarRespuestasSaludo = MessageTemplate
						.MatchConversationId("ResponderSaludo");
				ACLMessage respuesta = myAgent.receive(tratarRespuestasSaludo);
				if (respuesta != null) {
					// if (respuesta.getPerformative() == ACLMessage.PROPOSE) {
					System.out.println("[" + getLocalName()
							+ "]: Ya hablaremos despus "
							+ respuesta.getSender().getLocalName() + "!!");
					System.out.println();
					// }
				} else {
					block();
				}
			}
			if (listaInvitados.length == 0) {
				System.out
						.println("["
								+ getLocalName()
								+ "] : Soy el primero en llegar. Mejor voy a saludar al anfitrin!!\n");
			}
			doWait(2000);
			for (int i = 0; i < listaAnfitrion.length; i++) {
				ACLMessage cfp = new ACLMessage(ACLMessage.CFP);
				cfp.addReceiver(listaAnfitrion[i]);
				cfp.setConversationId("Saludo");
				cfp.setContent("Hola");
				System.out.println("[" + getLocalName()
						+ "]: Que tal va la noche "
						+ listaAnfitrion[i].getLocalName() + "!!!");
				send(cfp);
				doWait(2000);
				tratarRespuestasSaludo = MessageTemplate
						.MatchConversationId("ResponderSaludo");
				ACLMessage respuesta = myAgent.receive(tratarRespuestasSaludo);
				if (respuesta != null) {
					// if (respuesta.getPerformative() == ACLMessage.CFP) {
					System.out.println("[" + getLocalName()
							+ "]: Ya hablaremos despus "
							+ respuesta.getSender().getLocalName() + "!!");
					System.out.println();

					// }
				} else {
					block();
				}
			}

			fin = true;

		}

		public boolean done() {
			return fin;
		}


	}

	private class Escuchar extends CyclicBehaviour {
		MessageTemplate tratarSaludos;
		MessageTemplate tratarComida;

		public void action() {
			tratarSaludos = MessageTemplate.MatchConversationId("Saludo");
			tratarComida = MessageTemplate.MatchConversationId("Comida");
			ACLMessage msg = myAgent.receive(tratarSaludos);
			ACLMessage msg2 = myAgent.receive(tratarComida);
			if (msg != null) {
				// Se ha recibido un mensaje de Saludo y lo procesamos
				ACLMessage reply = msg.createReply();
				reply.setConversationId("ResponderSaludo");
				reply.setContent("Que pasa troncoo");
				// reply.setPerformative(ACLMessage.CFP);
				System.out.println("[" + getLocalName() + "]: Que pasa "
						+ msg.getSender().getLocalName() + "!!!");
				send(reply);
			} else if (msg2 != null) {
				// Se ha recibido un mensaje de Comida y lo procesamos
				ACLMessage reply2 = msg2.createReply();
				reply2.setConversationId("ResponderComida");
				Random rand = new Random();
				int ranNum = rand.nextInt(10 - 1 + 1) + 1;
				if (ranNum == 3) {
					reply2.setContent("Gin Tonic");
					bebida++;
					tragos++;
				} else if (ranNum <= 2) {
					reply2.setContent("Cerbeza");
					bebida++;
					tragos++;
				} else if (ranNum == 4) {
					reply2.setContent("Patxaran");
					bebida++;
					tragos++;
				} else if (ranNum == 5) {
					reply2.setContent("Martini");
					bebida++;
					tragos++;
				} else if (ranNum == 5) {
					reply2.setContent("Ron");
					bebida++;
					tragos++;
				} else if (ranNum == 6) {
					reply2.setContent("Whisky");
					bebida++;
					tragos++;
				} else if (ranNum == 7) {
					reply2.setContent("Agua");
					bebida--;
				} else if (ranNum > 7) {
					reply2.setContent("Comida");
					comida++;
				}
				reply2.setPerformative(ACLMessage.REQUEST);
				System.out.println("[" + getLocalName() + "]: Dame un poco de "
						+ reply2.getContent() + " "
						+ msg2.getSender().getLocalName() + "!!!");
				send(reply2);
			} else {
				block();
			}
		}
	}

	private class Comprobar extends TickerBehaviour {

		int minticks;

		public Comprobar(Agent a, long intervalo) {
			super(a, intervalo);
			minticks = 0;
		}

		public void reset() {
			super.reset();
		}

		protected void onTick() {
			MessageTemplate tratarRespuestasAdios;
			long tfin = System.currentTimeMillis() - tini;
			int nticks = getTickCount();
			minticks++;
			if (nticks == 10) {
				// Bebida = nivel de borrachera > 3
				if (bebida > 3) {
					for (int i = 0; i < listaAnfitrion.length; i++) {
						ACLMessage cfp = new ACLMessage(ACLMessage.CFP);
						cfp.addReceiver(listaAnfitrion[i]);
						cfp.setConversationId("Despedida");
						cfp.setContent("Adios");
						System.out.println("[" + getLocalName()
								+ "]: Uff ya llevo "+tragos+" tragos mejor me voy...");
						System.out.println("[" + getLocalName()
								+ "]: Bueno increible fiesta, se agradece "
								+ listaAnfitrion[i].getLocalName() + "!!!");
						send(cfp);
						doWait(2000);
						tratarRespuestasAdios = MessageTemplate
								.MatchConversationId("ResponderAdios");
						ACLMessage respuesta = myAgent
								.receive(tratarRespuestasAdios);
						if (respuesta != null) {
							System.out.println("[" + getLocalName()
									+ "]: Venga hasta otra!!!! "
									+ respuesta.getSender().getLocalName()
									+ "!!\n");
							System.out.println();
							try {
								DFService.deregister(myAgent);
							} catch (FIPAException e) {
								e.printStackTrace();
							}
							doDelete();
						} else {
							block();
						}
					}
				} else {
					Random rand = new Random();
					int ranNum = rand.nextInt(12 - 1 + 1) + 1;
					if (ranNum == 3) {
						System.out.println("[" + getLocalName()
								+ "]: Me aburroo\n");
					} else if (ranNum <= 2) {
						System.out.println("[" + getLocalName()
								+ "]: Que fieston!! Esto es increible!\n");
					} else if (ranNum == 4) {
						System.out.println("[" + getLocalName()
								+ "]: Me estoy emborrachando...\n");
					} else if (ranNum == 5) {
						System.out.println("[" + getLocalName()
								+ "]: Bailandooo bailandooo \n");
					}
					reset();
				}
			}
		}
	}

	private void buscarInvitados() {
		DFAgentDescription agentDescription = new DFAgentDescription();
		ServiceDescription serviceDescription = new ServiceDescription();
		serviceDescription.setType("party-guest");
		agentDescription.addServices(serviceDescription);

		try {
			DFAgentDescription[] result = DFService.search(this,
					agentDescription);
			listaInvitados = new AID[result.length - 1];
			// System.out.println("[" + getLocalName() + "] Invitados sala:");
			int f = 0;
			for (int i = 0; i < result.length; ++i) {
				if (result[i].getName().getLocalName()
						.equals(this.getLocalName()) != true) {
					listaInvitados[f] = result[i].getName();
					// System.out.println(result[i].getName().getLocalName());
					f++;
				}
			}
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
		// System.out.println();
	}

	private void buscarAnfitrion() {
		DFAgentDescription agentDescription = new DFAgentDescription();
		ServiceDescription serviceDescription = new ServiceDescription();
		serviceDescription.setType("party-host");
		agentDescription.addServices(serviceDescription);

		try {
			DFAgentDescription[] result = DFService.search(this,
					agentDescription);
			listaAnfitrion = new AID[result.length];
			// System.out.println("[" + getLocalName()
			// + "] Anfitriones de la fiesta:");
			for (int i = 0; i < result.length; ++i) {

				listaAnfitrion[i] = result[i].getName();
				// System.out.println(result[i].getName().getLocalName());
			}
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
		// System.out.println();
	}

}
