package Behaviours;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.SequentialBehaviour;

@SuppressWarnings("serial")
public class EjercicioHalterofilia extends SequentialBehaviour {
	int step;
	boolean finish;
	
	public EjercicioHalterofilia(Agent agente) {
		super(agente);
		finish = false;
		step = 1;
		System.out.println("MAXIMO MAZADO: Venga, 4 series de levantamientos, empezamos:");
		this.addSubBehaviour(new Repeticiones(myAgent, 15));
		this.addSubBehaviour(new Repeticiones(myAgent, 12));
		this.addSubBehaviour(new Repeticiones(myAgent, 10));
		this.addSubBehaviour(new Repeticiones(myAgent, 8));
	}
	
	// 4 Step Behaviour
	private class Repeticiones extends Behaviour {
		private int repeticion, tope;
		public Repeticiones(Agent agente, int tope) { super(agente); this.tope = tope; }
		
		public void onStart() { 
			repeticion = 1; 
			switch(tope) {
			case 15:
				System.out.println("MAZADO: Venga empezamos con una serie de 15.");
				break;
			case 12:
				System.out.println("MAZADO: Ahora 12 repes.");
				break;
			case 10:
				System.out.println("MAZADO: Venga tío que sólo son 10, sube unos kilos.");
				break;
			case 8:
				System.out.println("MAZADO: ¡La última de 8 dándolo todo!");
				break;
			}
		}
		
		public void action() {
			System.out.println("MAZADO: " + repeticion);
			block(100);
			repeticion++;
		}
		
		public boolean done() {
			return repeticion == tope + 1;
		}
	}
}
