package Behaviours;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;

import java.util.HashMap;

@SuppressWarnings("serial")
public class RayarColegas extends WakerBehaviour {
	HashMap<String, AID> agentes;
	
	public RayarColegas(Agent agente, int tiempo) { 
		super(agente, tiempo); 
	}
	
	public void onStart() {
		System.out.println("ADRIAN: ¡Comienza el ultra-entrenamiento-final-definitivo, Erik y Juan!.");
	}
	
	protected void onWake() {
		encontrarAgentes();
		myAgent.addBehaviour(new RayarErik(myAgent));
		myAgent.addBehaviour(new RayarJuan(myAgent));
		myAgent.addBehaviour(new WakerBehaviour(myAgent, 10000) {
			protected void onWake() {
				enviarMensaje("Tronista", "Nos vamos");
				enviarMensaje("AgenteMemeTodeto", "Nos vamos");
				enviarMensaje("Erik", "Nos vamos");
				enviarMensaje("Juan", "Nos vamos");
			}
		});	
	}
	
	public void enviarMensaje(String agente, String contenido) {
		ACLMessage inform = new ACLMessage(ACLMessage.INFORM);
        inform.addReceiver(agentes.get(agente));
        inform.setContent(contenido);
        inform.setConversationId("rayar" + agente);
        myAgent.send(inform);
	}
	
	public void encontrarAgentes() {
		DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType("Gimnasio");
        template.addServices(sd);
		try {		
          	DFAgentDescription[] encontrados = DFService.search(myAgent, template); 
          	agentes = new HashMap<String, AID>(encontrados.length);
            for (int i = 0; i < encontrados.length; ++i) {
            	AID a = encontrados[i].getName();
	        	agentes.put(a.getLocalName(), a);
            }
		} catch (FIPAException e) {
			e.printStackTrace();
		}
	}
	
	private class RayarErik extends Behaviour {
		boolean finished;
		public RayarErik(Agent agente) { super(agente); finished = false; }
		
		public void action() {
			enviarMensaje("Erik", "Hoy toca pecho, triceps.");
			block(1000);
			enviarMensaje("Erik", "Erik venga que te toca, joder, no seas vago.");
			block(3000);
			enviarMensaje("Erik", "Dios Erik, que llevamos ya 3 series y no has subido un puto kilo.");
			finished = true;
		}
		
		public boolean done() {
			return finished;
		}
	}
	
	private class RayarJuan extends Behaviour {
		boolean finished;
		public RayarJuan(Agent agente) { super(agente); finished = false; }
		
		public void action() {
			enviarMensaje("Juan", "Tu, no te calientes haciendo triceps que te lesionas.");
			block(4000);		
			enviarMensaje("Juan", "Si te duele el hombro haciendo pecho vete a un fisio.");
			finished = true;
		}
		
		public boolean done() {
			return finished;
		}
	}
}