package Gimnasio;
import java.util.HashMap;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

@SuppressWarnings("serial")
public class Erik extends Agent {
	HashMap<String, AID> agentes;
	
	protected void setup() {
		this.addBehaviour(new WakerBehaviour(this, 2000) {
			protected void onWake() {
				System.out.println(getLocalName().toUpperCase() + ": Joder que pereza, yo me quería quedar en casa a tocarme los ******.");
				preparar();
				MessageTemplate _mensaje = MessageTemplate.and( MessageTemplate.MatchConversationId("rayarErik"),  MessageTemplate.MatchPerformative(ACLMessage.INFORM));
				// Se bloquea esperando a lo que diga Adrian para luego responder
				// PRIMER MENSAJE
				ACLMessage mensaje1 = blockingReceive(_mensaje);
				System.out.println("ADRIAN: " + mensaje1.getContent());
				System.out.println("ERIK: Vale, bien.");
				
				// SEGUNDO MENSAJE
				ACLMessage mensaje2 = blockingReceive(_mensaje);
				System.out.println("ADRIAN: " + mensaje2.getContent());
				System.out.println("ERIK: Voy a mi ritmo. Lento.");
				
				// TERCER MENSAJE
				ACLMessage mensaje3 = blockingReceive(_mensaje);
				System.out.println("ADRIAN: " + mensaje3.getContent());
				System.out.println("ERIK: Soy un débil, que se le va a hacer.");
				
				ACLMessage mensaje4 = blockingReceive(_mensaje);
				if(mensaje4.getContent().compareTo("Nos vamos") == 0)
					takeDown();
			}
		});
    }
    
	public void preparar() {
		DFAgentDescription agentDescription = new DFAgentDescription();
		agentDescription.setName(getAID());
		ServiceDescription serviceDescription = new ServiceDescription();
		serviceDescription.setType("Gimnasio");
		serviceDescription.setName("Erik");
		agentDescription.addServices(serviceDescription);
		try {
			DFService.register(this, agentDescription);
		} catch(FIPAException e) {
			e.printStackTrace();
		}
	}
  
	protected void takeDown() {
		System.out.println("ERIK: Uff, al fin acabamos, ¡qué hambre tengo tiooooo!");
		try {
			DFService.deregister(this);
		} catch (FIPAException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		super.takeDown();
	}
}
