package Gimnasio;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

import java.util.HashMap;

@SuppressWarnings("serial")
public class Juan extends Agent {
	HashMap<String, AID> agentes;
	
	protected void setup() {
		this.addBehaviour(new WakerBehaviour(this, 2000) {
			protected void onWake() {
				System.out.println(myAgent.getLocalName().toUpperCase() + ": Venga a tope, que hoy me he metido bien de prote y macarrones.");
				preparar();
				MessageTemplate _mensaje = MessageTemplate.and( MessageTemplate.MatchConversationId("rayarJuan"),  MessageTemplate.MatchPerformative(ACLMessage.INFORM));
				// Se bloquea esperando a lo que diga Adrian
				// PRIMER MENSAJE
				ACLMessage mensaje1 = blockingReceive(_mensaje);
				System.out.println("ADRIAN: " + mensaje1.getContent());
				System.out.println("JUAN: Ya ya, es que triceps me encanta.");
				
				// SEGUNDO MENSAJE
				ACLMessage mensaje2 = blockingReceive(_mensaje);
				System.out.println("ADRIAN: " + mensaje2.getContent());
				System.out.println("JUAN: Joder tio es que me jode.");
				
				ACLMessage mensaje3 = blockingReceive(_mensaje);
				if(mensaje3.getContent().compareTo("Nos vamos") == 0)
					takeDown();
			};
		});
    }
    
	public void preparar() {
		DFAgentDescription agentDescription = new DFAgentDescription();
		agentDescription.setName(getAID());
		ServiceDescription serviceDescription = new ServiceDescription();
		serviceDescription.setType("Gimnasio");
		serviceDescription.setName("Juan");
		agentDescription.addServices(serviceDescription);
		try {
			DFService.register(this, agentDescription);
		} catch(FIPAException e){
			e.printStackTrace();
		}
	}
	
	protected void takeDown() {
		System.out.println("JUAN: Ahora una buena cena entra de puta madre.");
		try {
			DFService.deregister(this);
		} catch (FIPAException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		super.takeDown();
	}
}
