package Gimnasio;

import Behaviours.TonteriasDeTronistas;
import jade.core.Agent;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;

@SuppressWarnings("serial")
public class Tronista extends Agent {
	
	protected void setup() {
		preparar();
		addBehaviour(new TonteriasDeTronistas(this, 5000));
	}
	
	public void preparar() {
		DFAgentDescription agentDescription = new DFAgentDescription();
		agentDescription.setName(getAID());
		ServiceDescription serviceDescription = new ServiceDescription();
		serviceDescription.setType("Gimnasio");
		serviceDescription.setName("Tronista");
		agentDescription.addServices(serviceDescription);
		try {
			DFService.register(this, agentDescription);
		} catch(FIPAException e){
			e.printStackTrace();
		}
	}
	
	protected void takeDown() {
		try {
			DFService.deregister(this);
		} catch (FIPAException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		super.takeDown();
	}
}
