package Pelota;

import java.util.Random;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.SequentialBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;

public class Comentarista extends Agent {
	AID[] pelotari = null;
	private static final long serialVersionUID = 1L;

	protected void setup() {

		System.out.println("El " + getAID().getLocalName() + " ha llegado.");
		System.out.println();

		doWait(1000);
		buscarPelotaris();
		System.out
				.println("---------------------------------------------------------------------------------");
		System.out.println("[ " + getLocalName()
				+ "] : Hola a todos!!! \n Hoy vestido de rojo tendremos a "
				+ pelotari[1].getLocalName() + " que jugara contra "
				+ pelotari[0].getLocalName() + " que vestira de azul.");
		System.out.println("[ " + getLocalName()
				+ "] : Esperemos ver un buen partido!!");
		System.out
				.println("---------------------------------------------------------------------------------\n");
		System.out.println("");

		SequentialBehaviour comentar = new SequentialBehaviour();
		comentar.addSubBehaviour(new WakerBehaviour(this, 6000) {
			protected void onWake() {
				Random rand = new Random();
				int ranNum = rand.nextInt(2 - 1 + 1) + 1;
				if (ranNum == 1) {
					System.out
							.println("---------------------------------------------------");
					System.out.println("[" + getLocalName()
							+ "]: Pero que partidazo!!");
					System.out
							.println("---------------------------------------------------\n");

				} else {
					System.out
							.println("---------------------------------------------------");
					System.out.println("[" + getLocalName()
							+ "]: El pardido esta siendo aburridisimo...");
					System.out
							.println("---------------------------------------------------\n");

				}
			}
		});

		comentar.addSubBehaviour(new WakerBehaviour(this, 8000) {
			private static final long serialVersionUID = 1L;

			protected void onWake() {
				Random rand = new Random();
				int ranNum = rand.nextInt(2 - 1 + 1) + 1;
				if (ranNum == 1) {
					System.out
							.println("---------------------------------------------------");
					System.out
							.println("["
									+ getLocalName()
									+ "]: Hay un ambiente increible en el fronton. Como anima la gente!");
					System.out
							.println("---------------------------------------------------\n");
				} else {
					System.out
							.println("---------------------------------------------------");
					System.out
							.println("["
									+ getLocalName()
									+ "]: No hay mucha jente en el fronton. Pero por lo menos animan.");
					System.out
							.println("---------------------------------------------------\n");

				}
			}
		});

		comentar.addSubBehaviour(new WakerBehaviour(this, 9000) {
			private static final long serialVersionUID = 1L;

			protected void onWake() {
				doDelete();
				Random rand = new Random();
				int ranNum = rand.nextInt(2 - 1 + 1) + 1;
				if (ranNum == 1) {
					System.out
							.println("---------------------------------------------------");
					System.out
							.println("["
									+ getLocalName()
									+ "]: Lo sentimos mucho pero tenemos que transmitir un partido de futbol..................");
					System.out
							.println("---------------------------------------------------\n");
				} else {
					System.out
							.println("---------------------------------------------------");
					System.out
							.println("["
									+ getLocalName()
									+ "]: Cre.. que.. ha.. prob.. mas con l.. comu.. cación. Se corto.");
					System.out
							.println("---------------------------------------------------\n");

				}
			}
		});
		addBehaviour(comentar);
	}

	protected void takeDown() {
		System.out.println(getAID().getLocalName() + " se ha ido");
	}

	private void buscarPelotaris() {
		DFAgentDescription agentDescription = new DFAgentDescription();
		ServiceDescription serviceDescription = new ServiceDescription();

		serviceDescription.setType("Pelotari");
		agentDescription.addServices(serviceDescription);

		try {
			DFAgentDescription[] result = DFService.search(this,
					agentDescription);
			pelotari = new AID[result.length];
			// System.out.println("Bilatutako pelotariak:");
			for (int i = 0; i < result.length; ++i) {
				pelotari[i] = result[i].getName();
				// System.out.println(result[i].getName().getLocalName());
			}
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
		System.out.println();
	}
}
