package Pelota;

import java.util.Random;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.domain.AMSService;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

public class Juez extends Agent {
	AID[] pelotari = null;

	protected void setup() {
		System.out.println("El " + getAID().getLocalName() + " ha llegado.");
		System.out.println();

		doWait(2000);
		buscarPelotaris();
		addBehaviour(new listo());
		addBehaviour(new fin());

	}

	protected void takeDown() {
		System.out.println(getAID().getLocalName() + " se ha ido");
	}

	private class listo extends Behaviour {

		MessageTemplate tratarRespuestas;
		boolean fin = false;

		public void onStart() {
			System.out.println("[ " + getLocalName()
					+ " ] : Veamos si los pelotaris estan preparados...");
		}

		public void action() {

			ACLMessage cfp = new ACLMessage(ACLMessage.CFP);

			for (int i = 0; i < pelotari.length; i++) {

				cfp.addReceiver(pelotari[i]);
				cfp.setConversationId("listo");
				cfp.setContent("listo?");
				send(cfp);
			}
			for (int j = 0; j < pelotari.length; j++) {
				tratarRespuestas = MessageTemplate.and(
						MessageTemplate.MatchConversationId("listo"),
						MessageTemplate.MatchInReplyTo(cfp.getReplyWith()));
				ACLMessage respuesta = myAgent.receive(tratarRespuestas);
				if (respuesta != null) {
					if (respuesta.getPerformative() == ACLMessage.PROPOSE) {
					}
				} else {
					block();
				}
			}
			fin = true;

		}

		@Override
		public boolean done() {
			return fin;
		}

		public int onEnd() {
			addBehaviour(new echarChapa());
			return 0;
		}

	}

	private class echarChapa extends Behaviour {
		private int estado = 0;
		private int ranNum = 0;

		// Función que realiza MiComportamiento
		public void action() {
			switch (estado) {
			case 0:
				doWait(2000);
				System.out
						.println("[ "
								+ getLocalName()
								+ " ] : Bueno pues entonces empecemos! Echaremos la chapa!");
				Random rand = new Random();
				ranNum = rand.nextInt(2 - 1 + 1) + 1;
				estado = ranNum;
				break;
			case 1:
				System.out.println("[ " + getLocalName()
						+ " ] : El color que a salido es azul!");
				System.out.println();
				estado = 3;
				break;
			case 2:
				System.out.println("[ " + getLocalName()
						+ " ] : El color que a salido es rojo!");
				System.out.println();
				estado = 3;
				break;
			}

		}

		// Comprueba si el comportamiento ha finalizado.
		public boolean done() {
			return (estado > 2);
		}

		public int onEnd() {
			System.out.println("El juez comunica a los pelotaris quien saca");
			for (int i = 0; i < pelotari.length; i++) {

				ACLMessage msg = new ACLMessage(ACLMessage.REQUEST);

				msg.addReceiver(pelotari[i]);
				msg.setConversationId("saque");
				if (i == ranNum - 1) {
					msg.setContent("Saca");
				} else {
					msg.setContent("No saques");
				}

				// Envia el mensaje a los destinatarios
				send(msg);

				System.out.println("[ " + getLocalName() + " ] : "
						+ msg.getContent() + " " + pelotari[i].getLocalName());
			}
			System.out.println();

			return 0;
		}
	}

	private class fin extends CyclicBehaviour {

		public void action() {
			MessageTemplate tratarRespuestas = MessageTemplate.and(
					MessageTemplate.MatchPerformative(ACLMessage.INFORM),
					MessageTemplate.MatchConversationId("fin"));
			ACLMessage msg = myAgent.receive(tratarRespuestas);
			if (msg != null) {
				System.out.println("[ " + getLocalName()
						+ "] : El partido ha terminado. El ganador es "+msg.getSender().getLocalName()+"!!!");
				System.out.println("[ " + getLocalName()
						+ "] : El resultado es este: " + msg.getContent());
				for (int i = 0; i < pelotari.length; i++) {
					ACLMessage msg2 = new ACLMessage(ACLMessage.REQUEST);
					msg2.addReceiver(pelotari[i]);
					msg2.setConversationId("Fin");
					msg2.setContent("termina");
					send(msg2);
				}
				doDelete();
			} else {
				block();
			}

		}

	}

	private void buscarPelotaris() {
		DFAgentDescription agentDescription = new DFAgentDescription();
		ServiceDescription serviceDescription = new ServiceDescription();

		serviceDescription.setType("Pelotari");
		agentDescription.addServices(serviceDescription);

		try {
			DFAgentDescription[] result = DFService.search(this,
					agentDescription);
			pelotari = new AID[result.length];
			// System.out.println("Bilatutako pelotariak:");
			for (int i = 0; i < result.length; ++i) {
				pelotari[i] = result[i].getName();
				// System.out.println(result[i].getName().getLocalName());
			}
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
		System.out.println();
	}
}
