package Pelota;

import java.util.Random;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

public class Pelotari extends Agent {
	private static final long serialVersionUID = 1L;
	private AID[] pelotari = null;
	private int tantosfavor = 0;
	private int tantoscontra = 0;

	protected void setup() {

		DFAgentDescription description = new DFAgentDescription();
		description.setName(getAID());
		ServiceDescription serviceDescription = new ServiceDescription();
		serviceDescription.setType("Pelotari");
		serviceDescription.setName(getAID().getLocalName());
		description.addServices(serviceDescription);
		try {
			DFService.register(this, description);
			System.out.println(getAID().getLocalName() + " ha llegado.");
			System.out.println();
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}

		doWait(2000);
		addBehaviour(new listo());
		addBehaviour(new fin());
	}

	protected void takeDown() {
		System.out.println(getAID().getLocalName() + " se ha ido");
	}

	private class listo extends SimpleBehaviour {
		private boolean fin = false;

		public void action() {

			MessageTemplate mt = MessageTemplate
					.MatchPerformative(ACLMessage.CFP);
			ACLMessage msg = myAgent.receive(mt);
			if (msg != null) {
				ACLMessage reply = msg.createReply();
				reply.setPerformative(ACLMessage.PROPOSE);
				System.out.println("[ " + getLocalName() + " ] : Empecemos!");
				myAgent.send(reply);
				fin = true;
			} else {
				block();
			}

		}

		public int onEnd() {
			addBehaviour(new empezarPartido());
			return 0;
		}

		public boolean done() {
			return fin;
		}

	}

	private class empezarPartido extends CyclicBehaviour {

		boolean fin = false;
		boolean turno = false;

		public void onStart() {
			bilatuPelotari();
			MessageTemplate mt = MessageTemplate.and(
					MessageTemplate.MatchPerformative(ACLMessage.REQUEST),
					MessageTemplate.MatchConversationId("saque"));
			ACLMessage msg = myAgent.blockingReceive(mt);
			if (msg != null) {
				if (msg.getContent().equals("Saca")) {
					for (int i = 0; i < pelotari.length; i++) {
						ACLMessage msg2 = new ACLMessage(ACLMessage.REQUEST);
						msg2.addReceiver(pelotari[i]);
						msg2.setConversationId("respuesta");
						msg2.setContent("Buena");
						send(msg2);
						System.out
								.println("---------------------------------------------------\n");

						System.out.println("Saca [ " + getLocalName() + "] : "
								+ msg2.getContent());
					}
				}
			} else {
				block();
			}
		}

		public void action() {
			MessageTemplate tratarRespuestas = MessageTemplate.and(
					MessageTemplate.MatchPerformative(ACLMessage.REQUEST),
					MessageTemplate.MatchConversationId("respuesta"));
			ACLMessage msg = myAgent.receive(tratarRespuestas);
			if (msg != null) {

				Random rand = new Random();
				int ranNum = rand.nextInt(10 - 1 + 1) + 1;

				// contestar con otra respuesta
				ACLMessage reply = msg.createReply();
				reply.setPerformative(ACLMessage.REQUEST);
				reply.setConversationId("respuesta");

				if (ranNum < 5) {
					reply.setContent("Mala");
				} else {
					reply.setContent("Buena");
				}
				if (msg.getContent().equals("Buena")) {
					System.out.println("El resto de [ " + getLocalName()
							+ "] : " + reply.getContent());
					doWait(1000);
					send(reply);

				} else {
					doWait(2000);
					tantosfavor++;
					if (tantosfavor == 6) {
						System.out.println("[" + getLocalName()
								+ "]: Ganeee!!!!\n");
						System.out
								.println("---------------------------------------------------\n");
						ACLMessage msg2 = new ACLMessage(ACLMessage.INFORM);
						AID id = new AID();
						id.setLocalName("Juez");
						msg2.addReceiver(id);
						msg2.setConversationId("fin");
						msg2.setContent(getLocalName() + ": " + tantosfavor
								+ " " + msg.getSender().getLocalName() + ": "
								+ tantoscontra + "");
						send(msg2);
					} else {
						Random rand2 = new Random();
						int ranNum2 = rand2.nextInt(2 - 1 + 1) + 1;
						if (ranNum2 == 1) {
							System.out.println("[" + getLocalName()
									+ "]: Si!!.\n");
						} else {
							System.out.println("[" + getLocalName()
									+ "]: Vamos!!\n");
						}
						System.out.println(getLocalName() + ": " + tantosfavor
								+ "---" + msg.getSender().getLocalName() + ": "
								+ tantoscontra + "\n");
						System.out
								.println("---------------------------------------------------\n");
						System.out.println("Saca [ " + getLocalName() + "] : "
								+ reply.getContent());
						send(reply);
					}

				}
				if (reply.getContent().equals("Mala")) {
					tantoscontra++;
				}
			} else {
				block();
			}

		}

	}

	private class fin extends CyclicBehaviour {

		public void action() {
			MessageTemplate tratarRespuestas = MessageTemplate.and(
					MessageTemplate.MatchPerformative(ACLMessage.REQUEST),
					MessageTemplate.MatchConversationId("Fin"));
			ACLMessage msg = myAgent.receive(tratarRespuestas);
			if (msg != null) {
				doDelete();
			} else {
				block();
			}

		}

	}

	private void bilatuPelotari() {
		DFAgentDescription agentDescription = new DFAgentDescription();
		ServiceDescription serviceDescription = new ServiceDescription();

		serviceDescription.setType("Pelotari");
		agentDescription.addServices(serviceDescription);
		try {
			DFAgentDescription[] result = DFService.search(this,
					agentDescription);

			pelotari = new AID[result.length - 1];

			// System.out.println("Bilatutakoak:");
			for (int i = 0; i < result.length; ++i) {
				if (result[i].getName().getLocalName()
						.equals(this.getLocalName()) != true) {
					pelotari[0] = result[i].getName();
					// System.out.println(result[i].getName().getLocalName());
				}
			}
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
	}

}
