package Pelota;

import java.util.Random;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.TickerBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;

public class Publico extends Agent {

	private long tini;
	private AID[] pelotari = null;

	protected void setup() {

		System.out.println("El " + getAID().getLocalName() + " ha llegado.");
		System.out.println();
		doWait(1000);
		buscarPelotaris();
		addBehaviour(new animar(this, 1000));
		addBehaviour(new WakerBehaviour(this, 35000) {
			protected void onWake() {
				doDelete();
			}
		});
	}

	protected void takeDown() {
		System.out.println(getAID().getLocalName() + " ha dejado de animar");
	}

	private class animar extends TickerBehaviour {

		int minticks;

		public animar(Agent a, long intervalo) {
			super(a, intervalo);
			minticks = 0;
		}

		public void reset() {
			super.reset();
		}

		protected void onTick() {
			long tfin = System.currentTimeMillis() - tini;
			int nticks = getTickCount();
			minticks++;
			if (nticks == 6) {
				Random rand = new Random();
				int ranNum = rand.nextInt(2 - 1 + 1) + 1;
				Random rand2 = new Random();
				int ranNum2 = rand2.nextInt(3 - 1 + 1) + 1;
				if (ranNum2 == 1) {
					System.out
							.println("---------------------------------------------------");
					System.out.println("[" + getLocalName() + "]: "
							+ pelotari[ranNum - 1].getLocalName() + " "
							+ pelotari[ranNum - 1].getLocalName() + " "
							+ pelotari[ranNum - 1].getLocalName() + "");
					System.out
							.println("---------------------------------------------------\n");
				} else if (ranNum2 == 2) {
					System.out
							.println("---------------------------------------------------");
					System.out.println("[" + getLocalName()
							+ "]: Buuuuu, fueraaaaaa, que verguenzaaaa!!!!");
					System.out
							.println("---------------------------------------------------\n");

				} else if (ranNum2 == 3) {
					System.out
							.println("---------------------------------------------------");
					System.out.println("[" + getLocalName()
							+ "]: Aupa aupa aupaa!!!!!");
					System.out
							.println("---------------------------------------------------\n");

				}
				reset();
			} else {
			}
		}
	}

	private void buscarPelotaris() {
		DFAgentDescription agentDescription = new DFAgentDescription();
		ServiceDescription serviceDescription = new ServiceDescription();

		serviceDescription.setType("Pelotari");
		agentDescription.addServices(serviceDescription);

		try {
			DFAgentDescription[] result = DFService.search(this,
					agentDescription);
			pelotari = new AID[result.length];
			// System.out.println("Bilatutako pelotariak:");
			for (int i = 0; i < result.length; ++i) {
				pelotari[i] = result[i].getName();
				// System.out.println(result[i].getName().getLocalName());
			}
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
		System.out.println();
	}
}
