package agents;
/*
 * -gui cuatro:agents.CuatroDedos;dire:agents.Director;enfermera:agents.EnfermeraVaras;paco:agents.Paco;resto:agents.RestoDeLocos
 */
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;

public class Director extends Agent {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	AID[] listaAgentes;

	protected void setup() {

		addBehaviour(new WakerBehaviour(this, 100) {
			/**
			 * 
			 */
			private static final long serialVersionUID = 1L;

			protected void onWake() {
				DFAgentDescription template = new DFAgentDescription();
				ServiceDescription service = new ServiceDescription();
				service.setType("manicomio");
				template.addServices(service);
				try {
					DFAgentDescription[] result = DFService.search(myAgent,
							template);
					listaAgentes = new AID[result.length];
					for (int i = 0; i < result.length; i++) {
						listaAgentes[i] = result[i].getName();
					}
				} catch (FIPAException fe) {
					fe.printStackTrace();
				}

				ACLMessage message = new ACLMessage(ACLMessage.INFORM);
				for (int i = 0; i < listaAgentes.length; i++) {
					message.addReceiver(listaAgentes[i]);
				}
				message.setContent("Cuatrodedos, traeme un caf que ando con sed");
				message.setConversationId("direcVoice");
				myAgent.send(message);
				// Perform the request
			}
		});

		addBehaviour(new WakerBehaviour(this, 8000) {
			/**
			 * 
			 */
			private static final long serialVersionUID = 1L;

			protected void onWake() {
				System.out
						.println("Director (megfono): Por cierto, en una hora toca la revisin de los loc... digo, de los clientes ");
			}
		});

		addBehaviour(new WakerBehaviour(this, 16000) {
			/**
			 * 
			 */
			private static final long serialVersionUID = 1L;

			protected void onWake() {
				System.out
						.println("Director (megfono): En 45 minutos toca la revisin de los clientes ");
			}
		});

		addBehaviour(new WakerBehaviour(this, 24000) {
			/**
			 * 
			 */
			private static final long serialVersionUID = 1L;

			protected void onWake() {
				System.out
						.println("Director (megfono): No me toques ah que sabes que... Espera, esto est enchufado...? MIERDA. Digooo.. ");
				System.out
						.println("Director (megfono): En media hora toca la revisin de los clientes ");
			}
		});

		addBehaviour(new WakerBehaviour(this, 32000) {
			/**
			 * 
			 */
			private static final long serialVersionUID = 1L;

			protected void onWake() {
				System.out
						.println("Director (megfono): En un cuarto de hora toca la revisin de los clientes ");
			}
		});

		addBehaviour(new WakerBehaviour(this, 40000) {
			/**
			 * 
			 */
			private static final long serialVersionUID = 1L;

			protected void onWake() {
				System.out
						.println("Director (megfono): Es la hora de la revisin! y trae el caf cuatroDedos ");
			}
		});
	}
}
