package FS;
import jade.core.Agent;
import jade.core.behaviours.*;
import jade.wrapper.AgentContainer;
import jade.wrapper.AgentController;
import jade.domain.AMSService;
import jade.domain.FIPAAgentManagement.*;
import jade.lang.acl.*;
import jade.core.AID;
public class Agent1  extends Agent {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	//Steps used in behavior
	int step=0;
	
	//Parameters used by the agent
	int n_ExistingAgents=-1;
	int n_TargetAgents=-1;
	
	//Reader of parameters
	String strparam;
	
	//Container and Controller
	AgentContainer a_Container;
	AgentController a_Controller;
	
	//Parameters of new Agent
	Object[] newAgParam = new Object[4];
	
	private void SettingParameters()
	{
		strparam=Utilities.readArgument(GConstants.key_numberOfExistingAgents, getArguments());
		//System.out.println("param 1:"+strparam);
		if(Utilities.isStringAnInteger(strparam))
		{
			n_ExistingAgents=Integer.parseInt(strparam);
		}
		strparam=Utilities.readArgument(GConstants.key_numberOFAgents, getArguments());
		//System.out.println("param 2:"+strparam);
		if(Utilities.isStringAnInteger(strparam))
		{
			n_TargetAgents=Integer.parseInt(strparam);
		}
	}
	private void CreateAnAgent()
	{
		a_Container = getContainerController();
		try{
			newAgParam[0]=GConstants.key_numberOfExistingAgents;
			newAgParam[1]=n_ExistingAgents+1;
			newAgParam[2]=GConstants.key_numberOFAgents;
			newAgParam[3]=n_TargetAgents;
			//Only the first is important, the other just will be considered to make it
			newAgParam[0]=Utilities.parseArguments(newAgParam);
			a_Controller= a_Container.createNewAgent("agent"+(n_ExistingAgents+1), "FS.Agent1", newAgParam);
			a_Controller.start();
		}
		catch(Exception e)
		{
			System.out.println("Error creating new agent: "+e.getMessage());
		}
	}
	private void SayHelloMessage()
	{
		AID myId = getAID();
		AMSAgentDescription [] agents = null;
		try {
			SearchConstraints constraints = new SearchConstraints();
			constraints.setMaxResults(new Long(-1));
			agents = AMSService.search( this, new AMSAgentDescription (), constraints );
		}catch (Exception e)
		{
			System.out.println("Error "+ e);
		}
			ACLMessage msg = new ACLMessage(ACLMessage.INFORM);
			msg.setContent( "Hola todos :D" );

			for (int i=0; i<agents.length;i++){
				if(myId != agents[i].getName())
				msg.addReceiver( agents[i].getName() );
				
			}
			System.out.println(msg.getContent());
			send(msg);
		
	}
	private void ReplyHelloMessage()
	{
		ACLMessage msg = blockingReceive();
				{
					ACLMessage reply=msg.createReply();
					reply.setContent("Hola "+msg.getSender());
					reply.setPerformative(ACLMessage.INFORM);
					System.out.println(reply.getContent());
					send(reply);
				}
	}
	protected void setup()
	{
		SettingParameters();
		addBehaviour(new MyBehaviour(this));
	}
	class MyBehaviour extends SimpleBehaviour {
		
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		public MyBehaviour (Agent a)
		{
			super(a);
		}

		@Override
		public void action() {
			
			switch(step)
			{
			case 0:
			// This case will create a new Agent by each Agent existing until reach the target
				System.out.println("Hello I am the agent: "+getLocalName());
			//	System.out.println("There are: "+n_ExistingAgents);
			//	System.out.println(n_TargetAgents+": Is the target");
				if(n_ExistingAgents < n_TargetAgents)
					{
						CreateAnAgent();						
						step=1;
					}
				else
				{
					step=2;
				}
				break;
			case 1:
				 ReplyHelloMessage();
				 step=2;
					;
				break;
			case 2:
				SayHelloMessage();
					step=1;
				break;
			default:
				;
				break;
			}
		}

		@Override
		public boolean done() {
			// TODO Auto-generated method stub
			return false;
		}
		
	}
	
}
