package FS;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.*;
import jade.domain.AMSService;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.lang.acl.ACLMessage;
import jade.wrapper.AgentController;
import jade.wrapper.AgentContainer;

import java.awt.Point;
import java.util.Date;

import javax.swing.JOptionPane;
public class God extends Agent {

	/**
	 * 
	 */
	
	//Steps used in behavior
	int step=0;
	
	//Parameters used by the agent
	private int n_Cannibals=-1;
	private int n_Hunters=-1;
	
	//Reader of parameters
	String strparam;
	
	//Container and Controller
	AgentContainer a_Container;
	AgentController a_Controller;
	
	
	
	//Parameters of word
	private int n_Cycles=0;
	private int n_Phase=0;
	private String []buffer;
	private SwingBoard sgb;
	
	//SequentialBehave
	SequentialBehaviour sequentialUpdaterBehaviour = new SequentialBehaviour();
	
	
	private void settingParameters()
	{
		strparam=Utilities.readArgument(GConstants.key_numberOfCannibals, getArguments());
		//System.out.println("param 1:"+strparam);
		if(Utilities.isStringAnInteger(strparam))
		{
			n_Cannibals=Integer.parseInt(strparam);
		}
		strparam=Utilities.readArgument(GConstants.key_numberOfHunters, getArguments());
		//System.out.println("param 2:"+strparam);
		if(Utilities.isStringAnInteger(strparam))
		{
			n_Hunters=Integer.parseInt(strparam);
		}
	}
	private void createAnAgent(String type, String name)
	{
		a_Container = getContainerController();
		//Parameters of new Agent
		Object[] newAgParam=new Object[4];
		Point position = Utilities.getARandomPoint();
		try{
			newAgParam[0]=GConstants.key_positionX;
			newAgParam[1]=position.x;
			newAgParam[2]=GConstants.key_positionY;
			newAgParam[3]=position.y;
			//Only the first is important, the other just will be considered to make it
			newAgParam[0]=Utilities.parseArguments(newAgParam);
			//System.out.println(String.valueOf(newAgParam[0]));
			a_Controller= a_Container.createNewAgent(name, "FS."+type, newAgParam);
			a_Controller.start();
			
		}
		catch(Exception e)
		{
			System.out.println("Error creating new agent: "+e.getMessage());
		}
	}
	public void sendMessageBroadCast(String message, int type)
	{
		AID myId = getAID();
		AMSAgentDescription [] agents = null;
		try {
			SearchConstraints constraints = new SearchConstraints();
			constraints.setMaxResults(new Long(-1));
			agents = AMSService.search( this, new AMSAgentDescription (), constraints );
		}catch (Exception e)
		{
			System.out.println("Error "+ e);
		}
			ACLMessage msg = new ACLMessage(type);
			msg.setContent(message);

			for (int i=0; i<agents.length;i++){
				if(myId != agents[i].getName())
				msg.addReceiver( agents[i].getName() );
				
			}
			send(msg);
		
	}
	public void sendMessage(String receiver, String message, int type)
	{
		ACLMessage msg = new ACLMessage(type);
		msg.setContent(message);
		msg.addReceiver( new AID(receiver,AID.ISLOCALNAME));
		send(msg);
	}
	public void replyMessage(ACLMessage msg, String message, int type)
	{
				{
					ACLMessage reply=msg.createReply();
					reply.setContent(message);
					reply.setPerformative(type);
					//System.out.println(reply.getContent());
					send(reply);
				}
	}
	
	private static final long serialVersionUID = 1L;
	protected void setup()
	{
		settingParameters();
		sgb=new SwingBoard(n_Cannibals+n_Hunters);
		buffer = new String[GConstants.size_max_buffer];
		addBehaviour(new creator_Behaviour(this));
		sequentialUpdaterBehaviour.addSubBehaviour(new ask_Behaviour(this));
		sequentialUpdaterBehaviour.addSubBehaviour(new actualizeWorldBehaviour(this));
		//addBehaviour(sequentialUpdaterBehaviour);
		//addBehaviour(new actualizeWorldBehaviour(this));
		addBehaviour(new kill_behaviour(this,100000));
	}
	
	class creator_Behaviour extends SimpleBehaviour{

		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		public creator_Behaviour(Agent a)
		{
			super(a);
		}
		@Override
		public void action() {
			// TODO Auto-generated method stub
			switch(step)
			{
			case 0:
				int i;
				for (i=0;i<n_Cannibals;i++)
				{
					createAnAgent(GConstants.type_cannnibal,GConstants.type_cannnibal+i);
					sendMessage(GConstants.type_cannnibal+i,"Hola hijo mio",ACLMessage.INFORM);
				}
				for (i=0;i<n_Hunters;i++)
				{
					createAnAgent(GConstants.type_hunter,GConstants.type_hunter+i);
					sendMessage(GConstants.type_hunter+i,"Hola hijo mio",ACLMessage.INFORM);
				}
				step=2;
				break;	
			}
			
		}
		

		@Override
		public boolean done() {
			// TODO Auto-generated method stub
			return false;
		}
		
	}
	class ask_Behaviour extends CyclicBehaviour
	{

		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		public ask_Behaviour(Agent a){
			super(a);
		}
		@Override
		public void action() {
			// TODO Auto-generated method stub
			// add two more parameters PositionReferenced POINT, Topology INT
			sendMessageBroadCast(GConstants.pattern_AskPosition, ACLMessage.INFORM);
			
		}
		
	}
	class actualizeWorldBehaviour extends CyclicBehaviour
	{
		/**
		 * 
		 */
		public actualizeWorldBehaviour(Agent a)
		{
			super(a);
		}
		private static final long serialVersionUID = 1L;
		int n=0;
		ACLMessage msg=null;
		String content;
		@Override
		public void action() {
			// TODO Auto-generated method stub
			
			if(n<GConstants.size_max_buffer)
			{
				
				if((msg=receive())!=null)
				{
					content=msg.getContent();
					if(content.startsWith(GConstants.pattern_ReplyPost))
					{
						content=content.substring(content.indexOf(":")+1);
						buffer[n]=n_Phase+":"+content;
						System.out.println(buffer[n]);
						n++;
					}
				}
			}
			else
			{
				sgb.repaint();
				sgb.refreshBoard(buffer, n_Phase);
				buffer= new String[GConstants.size_max_buffer];
				System.out.println("Refreshing");
				n=0;
				if(n_Cycles==GConstants.cyclesTo_Phase)
				{
					n_Phase++;
					n_Cycles=0;
				}
				n_Cycles++;
			}
		}
		
	}
	class kill_behaviour extends WakerBehaviour
	{

		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		public kill_behaviour(Agent a, int wakeupDate) {
			super(a, wakeupDate);
			// TODO Auto-generated constructor stub
		}
		protected void handleElapsedTimeout()
		{
			JOptionPane.showMessageDialog(null,"Finish");
			
			sendMessageBroadCast(GConstants.pattern_Die,ACLMessage.INFORM);
			sgb.setVisible(false);
		}
		
		
	}
	
}
