package FS;
import javax.swing.*;
import java.util.ArrayList;
import java.awt.*;
public class SwingBoard extends JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private CellLabel [][]cannibalBoard= new CellLabel[GConstants.size_y_world][GConstants.size_x_world];
	private CellLabel [][]hunterBoard = new CellLabel[GConstants.size_y_world][GConstants.size_x_world];
	
	//these are constant icons that show the desired image on a label 
	private final ImageIcon imgCannibal = new ImageIcon(GConstants.icon_cannibal);
	private final ImageIcon imgHunter = new ImageIcon(GConstants.icon_hunter);
	
	private ArrayList<String>prevData;
	
	public SwingBoard(int nHumans)
	{
		int i;
	//initialization of world data
		prevData= new ArrayList<>();
		
	//initialization of board add cannibals and hunters	
		int x=0;
		int y=0;
		int totalCells = GConstants.size_y_world * GConstants.size_x_world;
		JPanel nPane;
		CellLabel Label;
		setLayout(new GridLayout(10,10));
		setBackground(Color.green);
	 //We have added labels without icons because they will be shown only when were necessary
	 
	 for (i=0; i<totalCells;i++)
	 {
		 nPane= new JPanel();
		 nPane.setBackground(Color.green);
		 nPane.setBorder(BorderFactory.createLineBorder(Color.black));
		 nPane.setLayout(new GridLayout(0,2));
		 
		 //add cannibal
		 Label = new CellLabel(x, y, GConstants.type_cannnibal);
		 
		 //add label to array (this will be handled by god"
		 cannibalBoard[y][x]= Label; 
		 
		 //add label to panel
		 nPane.add(Label);
		 
		 //add hunter
		 Label = new CellLabel(x, y, GConstants.type_hunter);
		 
		 //add label to the god's array
		 hunterBoard[y][x]= Label;
		 
		 //add label to panel
		 nPane.add(Label);
		
		 add(nPane);
		
		 //Changing location of labels
		 x++;
		 if(x==GConstants.size_x_world)
		 {
			 y++;
			 x=0;
		 }
		 
		 
	 }
	 setVisible(true);
	 
	}
	//this method will be called by god in order to refresh the world's board
	public void refreshBoard(String[]AgentsData, int act_phase)
	{
		clearPrevPhase(AgentsData,act_phase);
		fillBoard(AgentsData);
	}
	private void clearPrevPhase(String[]AgentsData, int n_Phase)
	{
		
		String []params=null;
		String s;
		int i=0,j;
		for(i=0;i<prevData.size();i++)
		{
			s=prevData.get(i);
			//0->phase 1->type 2->name 3->x 4->y
			params= s.split(":");
			if(!params[0].contentEquals(String.valueOf(n_Phase)))
			{
				prevData.remove(i);
				clearCell(params);
				i--;
			}
			else{
				j=0;
				while(!dataEquals(AgentsData[j],s))
					{j++;
					if(j==AgentsData.length)break;}
					if(j<AgentsData.length)
					{		
						prevData.remove(i);
						clearCell(params);
						i--;
					}
				}
			
		}
	}
	private boolean dataEquals(String a, String b)
	{
		String []a_Content=a.split(":");
		String []b_Content=b.split(":");
		System.out.println("a"+a);
		System.out.println("b"+b);
		//0->phase 1->type 2->name 3->x 4->y
		//if type=type and name=name
		if(a_Content.length<4||b_Content.length<4)return false;
		if(a_Content[1].contains(b_Content[1])&&a_Content[2].contentEquals(b_Content[2]))
		{
			return true;
		}
		return false;
	}
	private void clearCell(String []params)
	{
		int position_x=0;
		int position_y=0;
		if (params[1].contentEquals(GConstants.type_cannnibal))
		{
			position_x=Integer.parseInt(params[3]);
			position_y=Integer.parseInt(params[4]);
			cannibalBoard[position_y][position_x].removeStrAgentInside(params[2]);
			if(cannibalBoard[position_y][position_x].getStrAgentsInside().contentEquals(""))
			{
				cannibalBoard[position_y][position_x].setIcon(null);
			}
		}else if (params[1].contentEquals(GConstants.type_hunter))
		{
			position_x=Integer.parseInt(params[3]);
			position_y=Integer.parseInt(params[4]);
			hunterBoard[position_y][position_x].removeStrAgentInside(params[2]);
			if(hunterBoard[position_y][position_x].getStrAgentsInside().contentEquals(""))
			{
				hunterBoard[position_y][position_x].setIcon(null);
			}
		}
	}
	/* last version
	private void clearBoard(int phase)
	{
		clearPrevPhase(phase);
		int i, j;
		for (i=0; i< GConstants.size_y_world; i++)
		{
			for (j=0; j< GConstants.size_x_world;j++)
			{
				//cleaning the icon
				cannibalBoard[i][j].setIcon(null);
				hunterBoard[i][j].setIcon(null);
				
				//cleaning the description
				cannibalBoard[i][j].setStrAgentsInside("");
				hunterBoard[i][j].setStrAgentsInside("");
			}
		}
	}*/
	private void fillBoard(String[]AgentsData)
	{
		String []params=null;
		int position_x=0;
		int position_y=0;
		for( String data : AgentsData)
		{
			prevData.add(data);
			//be sure that the data have always 5 parameters
			//0->phase 1->type 2->name 3->x 4->y
			params= data.split(":");
			//be sure that the agents always send the parameter by the right way
			if (params[1].contentEquals(GConstants.type_cannnibal))
			{
				position_x=Integer.parseInt(params[3]);
				position_y=Integer.parseInt(params[4]);
				cannibalBoard[position_y][position_x].addStrAgentInside(params[2]);
				cannibalBoard[position_y][position_x].setIcon(imgCannibal);
			}else if (params[1].contentEquals(GConstants.type_hunter))
			{
				position_x=Integer.parseInt(params[3]);
				position_y=Integer.parseInt(params[4]);
				hunterBoard[position_y][position_x].addStrAgentInside(params[2]);
				hunterBoard[position_y][position_x].setIcon(imgHunter);
			}
		}
	}
}
