package agentes;

import jade.core.Agent;
import jade.core.AID;
import jade.core.behaviours.*;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;


public class CampoBaseAgent extends Agent {

	protected void setup() {
		addBehaviour(new CyclicBehaviour() {

			public void action() {
				final String lesion = "Lesion";
				final String info = "Como va la situacion meteorologica?";
				ACLMessage mensajeDeSerpa = blockingReceive();
				
                if (mensajeDeSerpa!= null)
                {
                	String message = mensajeDeSerpa.toString();
                	System.out.println(getLocalName() + ": acaba de recibir el siguiente mensaje: ");
                    System.out.println(message);
                    String messageContent= mensajeDeSerpa.getContent();
                    
                    
                	
                	if(messageContent.equals(info)){
                	
                	
               		 System.out.println(getLocalName() +": Enviando contestacion");
                        ACLMessage respuestaParaSerpa = mensajeDeSerpa.createReply();
                        respuestaParaSerpa.setPerformative( ACLMessage.INFORM );
                        respuestaParaSerpa.setContent("Parece que llega una tormenta, debeis subir mas rapido");
                        respuestaParaSerpa.addReceiver( mensajeDeSerpa.getSender() );
                        send(respuestaParaSerpa);
                        System.out.println(getLocalName() +": Enviando informacin al serpa");
                        System.out.println(respuestaParaSerpa.toString());
                        myAgent.doDelete();
                	}
                	else if (messageContent.equals(lesion)){
                		System.out.println(getLocalName() +": Preparandose para enviar un mensaje a la CruzRoja");
        	            AID idCruzRoja = new AID();
        	            idCruzRoja.setLocalName("CruzRoja");
        	    	ACLMessage mensajeParaCruzRoja = new ACLMessage(ACLMessage.INFORM);
        	    	
        	    	 mensajeParaCruzRoja.setSender(getAID());
        	         mensajeParaCruzRoja.addReceiver(idCruzRoja);
        	         mensajeParaCruzRoja.setContent("El Serpa "+mensajeDeSerpa.getSender().getName()+" ha sufrido una lesion");
        	         send(mensajeParaCruzRoja);
                	}
                	
                
                    
                    
               
			}}
		});

	}
}
