package agentes;

import jade.core.Agent;
import jade.core.AID;
import jade.core.behaviours.*;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

public class CruzRojaAgent extends Agent {
	protected void setup() {
		ACLMessage mensajeParaCampoBase = blockingReceive();
		if (mensajeParaCampoBase != null) {
			String message = mensajeParaCampoBase.toString();
			System.out.println(getLocalName()
					+ ": acaba de recibir el siguiente mensaje: ");
			System.out.println(message);
			String messageContent = mensajeParaCampoBase.getContent();
			
			addBehaviour(new ThreeStepBehaviour());
		}
	}

	private class ThreeStepBehaviour extends Behaviour {
		private int step = 1;

		public void onStart() {
			System.out
					.println("Comienzo de un comportamiento general con onStart, action, done y onEnd.");
			super.onStart();

		}

		public void action() {
			switch (step) {
			case 1:
				
				System.out.println("Arranca el helicoptero, tenemos una emergencia!!");
				break;
			case 2:

				System.out.println(getLocalName()
						+ ": Preparandose para enviar un mensaje a receptor");
				AID idSerpa = new AID();
				idSerpa.setLocalName("Serpa");
				ACLMessage mensajeParaSerpa = new ACLMessage(
						ACLMessage.INFORM);

				mensajeParaSerpa.setSender(getAID());
				mensajeParaSerpa.addReceiver(idSerpa);
				mensajeParaSerpa.setContent("Cura realizada con exito, puede continuar");
				send(mensajeParaSerpa);

				break;
			case 3:
				
				System.out.println("Operacion 3");
				
				AID idCampoBase = new AID();
				idCampoBase.setLocalName("CampoBase");
				ACLMessage respuestaParaCampoBase = new ACLMessage(ACLMessage.INFORM);
				respuestaParaCampoBase.setSender(getAID());
				respuestaParaCampoBase.addReceiver(idCampoBase);
				respuestaParaCampoBase.setContent("Cura realizada.");
				send(respuestaParaCampoBase);
				
				break;
			}

			step++;
		}

		public boolean done() {
			return step == 4;
		}

		public int onEnd() {
			myAgent.doDelete();
			System.out.println(getLocalName()
					+ " dice: Continuo!.");
			return super.onEnd();
		}
	} 
}
